/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.http;

import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import com.alipay.sofa.rpc.server.ServerHandler;
import com.alipay.sofa.rpc.server.http.Http1ServerTask;
import com.alipay.sofa.rpc.server.http.Http2ServerTask;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpServerHandler
implements ServerHandler {
    protected Map<String, Invoker> invokerMap = new ConcurrentHashMap<String, Invoker>();
    protected AtomicInteger processingCount = new AtomicInteger(0);
    protected ThreadPoolExecutor bizThreadPool;

    public Map<String, Invoker> getInvokerMap() {
        return this.invokerMap;
    }

    public AtomicInteger getProcessingCount() {
        return this.processingCount;
    }

    @Override
    public void registerChannel(AbstractChannel nettyChannel) {
    }

    @Override
    public void unRegisterChannel(AbstractChannel nettyChannel) {
    }

    public void handleHttp1Request(SofaRequest request, ChannelHandlerContext ctx, boolean keepAlive) {
        Http1ServerTask task = new Http1ServerTask(this, request, ctx, keepAlive);
        this.processingCount.incrementAndGet();
        try {
            task.run();
        }
        catch (RejectedExecutionException e) {
            this.processingCount.decrementAndGet();
            throw e;
        }
    }

    public void handleHttp2Request(int streamId, SofaRequest request, ChannelHandlerContext ctx, Http2ConnectionEncoder encoder) {
        Http2ServerTask task = new Http2ServerTask(this, request, ctx, streamId, encoder);
        this.processingCount.incrementAndGet();
        try {
            task.run();
        }
        catch (RejectedExecutionException e) {
            this.processingCount.decrementAndGet();
            throw e;
        }
    }

    protected boolean isEmpty() {
        return this.invokerMap == null || this.invokerMap.isEmpty();
    }

    protected Method getMethod(String serviceName, String methodName) {
        return ReflectCache.getMethodCache(serviceName, methodName);
    }

    public boolean checkService(String serviceName, String methodName) {
        Invoker invoker = this.invokerMap.get(serviceName);
        return invoker instanceof ProviderProxyInvoker && this.getMethod(serviceName, methodName) != null;
    }

    public ThreadPoolExecutor getBizThreadPool() {
        return this.bizThreadPool;
    }

    public HttpServerHandler setBizThreadPool(ThreadPoolExecutor bizThreadPool) {
        this.bizThreadPool = bizThreadPool;
        return this;
    }
}

