/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.config.AbstractIdConfig;
import com.alipay.sofa.rpc.config.ConfigValueHelper;
import com.alipay.sofa.rpc.listener.ChannelListener;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.ServerFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServerConfig
extends AbstractIdConfig
implements Serializable {
    private static final long serialVersionUID = -574374673831680403L;
    protected String protocol = RpcConfigs.getStringValue("default.protocol");
    protected String host = RpcConfigs.getStringValue("server.host");
    protected int port = RpcConfigs.getIntValue("server.port.start");
    protected String contextPath = RpcConfigs.getStringValue("server.context.path");
    protected int ioThreads = RpcConfigs.getIntValue("server.ioThreads");
    protected String threadPoolType = RpcConfigs.getStringValue("server.pool.type");
    protected int coreThreads = RpcConfigs.getIntValue("server.pool.core");
    protected int maxThreads = RpcConfigs.getIntValue("server.pool.max");
    protected boolean telnet = RpcConfigs.getBooleanValue("server.telnet");
    protected String queueType = RpcConfigs.getStringValue("server.pool.queue.type");
    protected int queues = RpcConfigs.getIntValue("server.pool.queue");
    protected int aliveTime = RpcConfigs.getIntValue("server.pool.aliveTime");
    protected boolean preStartCore = RpcConfigs.getBooleanValue("server.pool.pre.start");
    protected int accepts = RpcConfigs.getIntValue("server.accepts");
    @Deprecated
    protected int payload = RpcConfigs.getIntValue("transport.payload.max");
    protected String serialization = RpcConfigs.getStringValue("default.serialization");
    @Deprecated
    protected String dispatcher = "message";
    protected Map<String, String> parameters;
    protected String virtualHost;
    protected Integer virtualPort;
    protected transient List<ChannelListener> onConnect;
    protected boolean epoll = RpcConfigs.getBooleanValue("server.epoll");
    protected boolean daemon = RpcConfigs.getBooleanValue("server.daemon");
    protected boolean adaptivePort = RpcConfigs.getBooleanValue("server.adaptive.port");
    protected String transport = RpcConfigs.getStringValue("default.transport");
    protected boolean autoStart = RpcConfigs.getBooleanValue("server.auto.start");
    protected int stopTimeout = RpcConfigs.getIntValue("server.stop.timeout");
    protected boolean keepAlive = RpcConfigs.getBooleanValue("transport.server.keepAlive");
    private volatile transient Server server;
    private transient String boundHost;

    public synchronized Server buildIfAbsent() {
        if (this.server != null) {
            return this.server;
        }
        this.server = ServerFactory.getServer(this);
        return this.server;
    }

    public synchronized void destroy() {
        ServerFactory.destroyServer(this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ServerConfig setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ServerConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ServerConfig setPort(int port) {
        if (!NetUtils.isRandomPort(port) && NetUtils.isInvalidPort(port)) {
            throw ExceptionUtils.buildRuntime("server.port", port + "", "port must between -1 and 65535 (-1 means random port)");
        }
        this.port = port;
        return this;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServerConfig setContextPath(String contextPath) {
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        this.contextPath = contextPath;
        return this;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public ServerConfig setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
        return this;
    }

    public String getThreadPoolType() {
        return this.threadPoolType;
    }

    public ServerConfig setThreadPoolType(String threadPoolType) {
        this.threadPoolType = threadPoolType;
        return this;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public ServerConfig setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public ServerConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public boolean isTelnet() {
        return this.telnet;
    }

    public ServerConfig setTelnet(boolean telnet) {
        this.telnet = telnet;
        return this;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public ServerConfig setQueueType(String queueType) {
        this.queueType = queueType;
        return this;
    }

    public int getQueues() {
        return this.queues;
    }

    public ServerConfig setQueues(int queues) {
        this.queues = queues;
        return this;
    }

    public int getAliveTime() {
        return this.aliveTime;
    }

    public ServerConfig setAliveTime(int aliveTime) {
        this.aliveTime = aliveTime;
        return this;
    }

    public boolean isPreStartCore() {
        return this.preStartCore;
    }

    public ServerConfig setPreStartCore(boolean preStartCore) {
        this.preStartCore = preStartCore;
        return this;
    }

    public int getAccepts() {
        return this.accepts;
    }

    public ServerConfig setAccepts(int accepts) {
        ConfigValueHelper.checkPositiveInteger("server.accept", accepts);
        this.accepts = accepts;
        return this;
    }

    public int getPayload() {
        return this.payload;
    }

    public ServerConfig setPayload(int payload) {
        this.payload = payload;
        return this;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public ServerConfig setSerialization(String serialization) {
        this.serialization = serialization;
        return this;
    }

    public String getDispatcher() {
        return this.dispatcher;
    }

    public ServerConfig setDispatcher(String dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ServerConfig setParameters(Map<String, String> parameters) {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, String>();
            this.parameters.putAll(parameters);
        }
        return this;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public ServerConfig setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public Integer getVirtualPort() {
        return this.virtualPort;
    }

    public ServerConfig setVirtualPort(Integer virtualPort) {
        this.virtualPort = virtualPort;
        return this;
    }

    public List<ChannelListener> getOnConnect() {
        return this.onConnect;
    }

    public ServerConfig setOnConnect(List<ChannelListener> onConnect) {
        this.onConnect = onConnect;
        return this;
    }

    public boolean isEpoll() {
        return this.epoll;
    }

    public ServerConfig setEpoll(boolean epoll) {
        this.epoll = epoll;
        return this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public ServerConfig setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public String getTransport() {
        return this.transport;
    }

    public ServerConfig setTransport(String transport) {
        this.transport = transport;
        return this;
    }

    public boolean isAdaptivePort() {
        return this.adaptivePort;
    }

    public ServerConfig setAdaptivePort(boolean adaptivePort) {
        this.adaptivePort = adaptivePort;
        return this;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public ServerConfig setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public ServerConfig setStopTimeout(int stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public ServerConfig setBoundHost(String boundHost) {
        this.boundHost = boundHost;
        return this;
    }

    public String getBoundHost() {
        return this.boundHost;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public ServerConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerConfig other = (ServerConfig)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }

    public String toString() {
        return "ServerConfig [protocol=" + this.protocol + ", port=" + this.port + ", host=" + this.host + "]";
    }
}

