/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import org.apache.hugegraph.pd.KvService;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.upgrade.VersionScriptFactory;
import org.apache.hugegraph.pd.upgrade.VersionUpgradeScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeService.class);
    private static final String VERSION_KEY = "DATA_VERSION";
    private static final String RUN_LOG_PREFIX = "SCRIPT_RUN_LOG";
    private final PDConfig pdConfig;
    private final KvService kvService;

    public UpgradeService(PDConfig pdConfig) {
        this.pdConfig = pdConfig;
        this.kvService = new KvService(pdConfig);
    }

    public void upgrade() throws PDException {
        log.info("upgrade service start");
        VersionScriptFactory factory = VersionScriptFactory.getInstance();
        String dataVersion = this.getDataVersion();
        log.info("now db data version : {}", (Object)dataVersion);
        for (VersionUpgradeScript script : factory.getScripts()) {
            if (this.isExecuted(script.getClass().getName()) && script.isRunOnce()) {
                log.info("Script {} is Executed and is run once", (Object)script.getClass().getName());
                continue;
            }
            if (dataVersion == null && !script.isRunWithoutDataVersion() || dataVersion != null && !this.versionCompare(dataVersion, script.getHighVersion(), script.getLowVersion())) {
                log.info("Script {} is did not match version requirements, current data version:{}, current version:{}script run version({} to {}), run without data version:{}", new Object[]{script.getClass().getName(), dataVersion, "1.5.0", script.getHighVersion(), script.getLowVersion(), script.isRunWithoutDataVersion()});
                continue;
            }
            script.runInstruction(this.pdConfig);
            this.logRun(script.getClass().getName());
        }
        this.writeCurrentDataVersion();
    }

    private boolean isExecuted(String className) throws PDException {
        String ret = this.kvService.get("SCRIPT_RUN_LOG/" + className);
        return ret.length() > 0;
    }

    private void logRun(String className) throws PDException {
        this.kvService.put("SCRIPT_RUN_LOG/" + className, "1.5.0");
    }

    private String getDataVersion() throws PDException {
        return this.kvService.get(VERSION_KEY);
    }

    private boolean versionCompare(String dataVersion, String high, String low) {
        String currentVersion = "1.5.0";
        return !(!high.equals("UNLIMITED_VERSION") && high.compareTo(dataVersion) < 0 || !low.equals("UNLIMITED_VERSION") && low.compareTo(currentVersion) > 0);
    }

    private void writeCurrentDataVersion() throws PDException {
        log.info("update db version to {}", (Object)"1.5.0");
        this.kvService.put(VERSION_KEY, "1.5.0");
    }
}

