/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hugegraph.pd.RegistryService;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.model.PromTargetsModel;
import org.apache.hugegraph.pd.rest.MemberAPI;
import org.apache.hugegraph.pd.service.PDService;
import org.apache.hugegraph.pd.util.HgMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PromTargetsService {
    private static final Logger log = LoggerFactory.getLogger(PromTargetsService.class);
    private final PromTargetsModel pdModel = PromTargetsModel.of().addLabel("__app_name", "pd").setScheme("http").setMetricsPath("/actuator/prometheus");
    private final PromTargetsModel storeModel = PromTargetsModel.of().addLabel("__app_name", "store").setScheme("http").setMetricsPath("/actuator/prometheus");
    private final HgMapCache<String, Set<String>> targetsCache = HgMapCache.expiredOf((long)86400000L);
    @Autowired
    private PDConfig pdConfig;
    @Autowired
    private PDService pdService;
    private RegistryService register;

    private RegistryService getRegister() {
        if (this.register == null) {
            this.register = new RegistryService(this.pdConfig);
        }
        return this.register;
    }

    public List<PromTargetsModel> getAllTargets() {
        LinkedList<PromTargetsModel> res = new LinkedList<PromTargetsModel>();
        List buf = this.toModels(this.getRegister().getNodes(Query.newBuilder().build()));
        if (buf != null) {
            res.addAll(buf);
        }
        res.add(this.getPdTargets());
        res.add(this.getStoreTargets());
        return res;
    }

    public List<PromTargetsModel> getTargets(String appName) {
        HgAssert.isArgumentNotNull((Object)appName, (String)"appName");
        switch (appName) {
            case "pd": {
                return Collections.singletonList(this.getPdTargets());
            }
            case "store": {
                return Collections.singletonList(this.getStoreTargets());
            }
        }
        return this.toModels(this.getRegister().getNodes(Query.newBuilder().setAppName(appName).build()));
    }

    private PromTargetsModel getPdTargets() {
        return this.setTargets(this.pdModel, () -> this.mergeCache("pd", this.getPdAddresses()));
    }

    private PromTargetsModel getStoreTargets() {
        return this.setTargets(this.storeModel, () -> this.mergeCache("store", this.getStoreAddresses()));
    }

    private PromTargetsModel setTargets(PromTargetsModel model, Supplier<Set<String>> supplier) {
        return model.setTargets(supplier.get()).setClusterId(String.valueOf(this.pdConfig.getClusterId()));
    }

    private Set<String> mergeCache(String key, Set<String> set) {
        HashSet<String> buf = (HashSet<String>)this.targetsCache.get((Object)key);
        if (buf == null) {
            buf = new HashSet<String>();
            this.targetsCache.put((Object)key, buf);
        }
        if (set != null) {
            buf.addAll(set);
        }
        return buf;
    }

    private List<PromTargetsModel> toModels(NodeInfos info) {
        if (info == null) {
            return null;
        }
        List nodes = info.getInfoList();
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        List<PromTargetsModel> res = nodes.stream().map(e -> {
            Map labels = e.getLabelsMap();
            String target = (String)labels.get("target");
            if (HgAssert.isInvalid((String[])new String[]{target})) {
                return null;
            }
            PromTargetsModel model = PromTargetsModel.of();
            model.addTarget(target);
            model.addLabel("__app_name", e.getAppName());
            labels.forEach((k, v) -> {
                switch (k = k.trim()) {
                    case "metrics": {
                        model.setMetricsPath(v.trim());
                        break;
                    }
                    case "scheme": {
                        model.setScheme(v.trim());
                        break;
                    }
                    default: {
                        if (!k.startsWith("__")) break;
                        model.addLabel(k, v);
                    }
                }
            });
            return model;
        }).filter(e -> e != null).collect(Collectors.toList());
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    private Set<String> getPdAddresses() {
        MemberAPI.CallStreamObserverWrap response = new MemberAPI.CallStreamObserverWrap();
        this.pdService.getMembers(Pdpb.GetMembersRequest.newBuilder().build(), (StreamObserver)response);
        List members = null;
        try {
            members = ((Pdpb.GetMembersResponse)response.get().get(0)).getMembersList();
        }
        catch (Throwable e2) {
            log.error("Failed to get all pd members.", e2);
        }
        HashSet<String> res = new HashSet<String>();
        if (members != null) {
            members.stream().forEach(e -> res.add(e.getRestUrl()));
        }
        return res;
    }

    private Set<String> getStoreAddresses() {
        HashSet<String> res = new HashSet<String>();
        List stores = null;
        try {
            stores = this.pdService.getStoreNodeService().getStores();
        }
        catch (PDException e2) {
            log.error("Failed to get all stores.", (Throwable)e2);
        }
        if (stores != null) {
            stores.stream().forEach(e -> {
                String buf = this.getRestAddress(e);
                if (buf != null) {
                    res.add(buf);
                }
            });
        }
        return res;
    }

    private String getRestAddress(Metapb.Store store) {
        Object address = store.getAddress();
        if (address == null || ((String)address).isEmpty()) {
            return null;
        }
        try {
            Optional<String> port = store.getLabelsList().stream().map(e -> {
                if ("rest.port".equals(e.getKey())) {
                    return e.getValue();
                }
                return null;
            }).filter(e -> e != null).findFirst();
            if (port.isPresent()) {
                address = ((String)address).substring(0, ((String)address).indexOf(58) + 1);
                address = (String)address + port.get();
            }
        }
        catch (Throwable t) {
            log.error("Failed to extract the REST address of store, cause by:", t);
        }
        return address;
    }
}

