/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.pulse.HgPdPulseGrpc;
import org.apache.hugegraph.pd.grpc.pulse.PulseRequest;
import org.apache.hugegraph.pd.grpc.pulse.PulseResponse;
import org.apache.hugegraph.pd.meta.MetadataFactory;
import org.apache.hugegraph.pd.meta.QueueStore;
import org.apache.hugegraph.pd.pulse.PDPulseSubject;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@GRpcService
public class PDPulseService
extends HgPdPulseGrpc.HgPdPulseImplBase {
    private static final Logger log = LoggerFactory.getLogger(PDPulseService.class);
    private static final Supplier<List<Metapb.QueueItem>> QUEUE_RETRIEVE_FUNCTION = () -> Collections.emptyList();
    private static final Function<Metapb.QueueItem, Boolean> QUEUE_ITEM_BOOLEAN_FUNCTION = e -> true;
    private static final Function<String, Boolean> QUEUE_REMOVE_FUNCTION = e -> true;
    @Autowired
    private PDConfig pdConfig;
    private QueueStore queueStore = null;

    public PDPulseService() {
        PDPulseSubject.setQueueRetrieveFunction(() -> this.getQueue());
        PDPulseSubject.setQueueDurableFunction((Function)this.getQueueDurableFunction());
        PDPulseSubject.setQueueRemoveFunction((Function)this.getQueueRemoveFunction());
    }

    public StreamObserver<PulseRequest> pulse(StreamObserver<PulseResponse> responseObserver) {
        return PDPulseSubject.addObserver(responseObserver);
    }

    private Function<String, Boolean> getQueueRemoveFunction() {
        return itemId -> {
            try {
                this.getQueueStore().removeItem(itemId);
                return true;
            }
            catch (Throwable t) {
                log.error("Failed to remove item from store, item-id: " + itemId + ", cause by:", t);
                return false;
            }
        };
    }

    private Function<Metapb.QueueItem, Boolean> getQueueDurableFunction() {
        return item -> {
            try {
                this.getQueueStore().addItem(item);
                return true;
            }
            catch (Throwable t) {
                log.error("Failed to add item to store, item: " + item.toString() + ", cause by:", t);
                return false;
            }
        };
    }

    private boolean isLeader() {
        return RaftEngine.getInstance().isLeader();
    }

    private List<Metapb.QueueItem> getQueue() {
        if (!this.isLeader()) {
            return Collections.emptyList();
        }
        try {
            return this.getQueueStore().getQueue();
        }
        catch (Throwable t) {
            log.error("Failed to retrieve queue from QueueStore, cause by:", t);
            log.warn("Returned empty queue list.");
            return Collections.emptyList();
        }
    }

    private QueueStore getQueueStore() {
        if (this.queueStore == null) {
            this.queueStore = MetadataFactory.newQueueStore((PDConfig)this.pdConfig);
        }
        return this.queueStore;
    }
}

