/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.hugegraph.pd.KvService;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.kv.K;
import org.apache.hugegraph.pd.grpc.kv.KResponse;
import org.apache.hugegraph.pd.grpc.kv.Kv;
import org.apache.hugegraph.pd.grpc.kv.KvResponse;
import org.apache.hugegraph.pd.grpc.kv.KvServiceGrpc;
import org.apache.hugegraph.pd.grpc.kv.LockRequest;
import org.apache.hugegraph.pd.grpc.kv.LockResponse;
import org.apache.hugegraph.pd.grpc.kv.ScanPrefixResponse;
import org.apache.hugegraph.pd.grpc.kv.TTLRequest;
import org.apache.hugegraph.pd.grpc.kv.TTLResponse;
import org.apache.hugegraph.pd.grpc.kv.WatchKv;
import org.apache.hugegraph.pd.grpc.kv.WatchRequest;
import org.apache.hugegraph.pd.grpc.kv.WatchResponse;
import org.apache.hugegraph.pd.grpc.kv.WatchState;
import org.apache.hugegraph.pd.grpc.kv.WatchType;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.raft.RaftStateListener;
import org.apache.hugegraph.pd.service.ServiceGrpc;
import org.apache.hugegraph.pd.watch.KvWatchSubject;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@GRpcService
public class KvServiceGrpcImpl
extends KvServiceGrpc.KvServiceImplBase
implements RaftStateListener,
ServiceGrpc {
    private static final Logger log = LoggerFactory.getLogger(KvServiceGrpcImpl.class);
    private final ManagedChannel channel = null;
    KvService kvService;
    AtomicLong count = new AtomicLong();
    String msg = "node is not leader,it is necessary to  redirect to the leader on the client";
    @Autowired
    private PDConfig pdConfig;
    private KvWatchSubject subjects;
    private ScheduledExecutorService executor;

    @PostConstruct
    public void init() {
        RaftEngine.getInstance().init(this.pdConfig.getRaft());
        RaftEngine.getInstance().addStateListener((RaftStateListener)this);
        this.kvService = new KvService(this.pdConfig);
        this.subjects = new KvWatchSubject(this.pdConfig);
        this.executor = Executors.newScheduledThreadPool(1);
        this.executor.scheduleWithFixedDelay(() -> {
            if (this.isLeader()) {
                this.subjects.keepClientAlive();
            }
        }, 0L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void put(Kv request, StreamObserver<KvResponse> responseObserver) {
        KvResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getPutMethod(), (Object)request, responseObserver);
            return;
        }
        KvResponse.Builder builder = KvResponse.newBuilder();
        try {
            String key = request.getKey();
            String value = request.getValue();
            this.kvService.put(key, value);
            WatchKv watchKV = this.getWatchKv(key, value);
            this.subjects.notifyAllObserver(key, WatchType.Put, new WatchKv[]{watchKV});
            response = builder.setHeader(this.getResponseHeader()).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getPutMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void get(K request, StreamObserver<KResponse> responseObserver) {
        KResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getGetMethod(), (Object)request, responseObserver);
            return;
        }
        KResponse.Builder builder = KResponse.newBuilder();
        try {
            String value = this.kvService.get(request.getKey());
            builder.setHeader(this.getResponseHeader());
            if (value != null) {
                builder.setValue(value);
            }
            response = builder.build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getGetMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void delete(K request, StreamObserver<KvResponse> responseObserver) {
        KvResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getDeleteMethod(), (Object)request, responseObserver);
            return;
        }
        KvResponse.Builder builder = KvResponse.newBuilder();
        try {
            String key = request.getKey();
            Kv deleted = this.kvService.delete(key);
            if (deleted.getValue() != null) {
                WatchKv watchKV = this.getWatchKv(deleted.getKey(), deleted.getValue());
                this.subjects.notifyAllObserver(key, WatchType.Delete, new WatchKv[]{watchKV});
            }
            response = builder.setHeader(this.getResponseHeader()).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getDeleteMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void deletePrefix(K request, StreamObserver<KvResponse> responseObserver) {
        KvResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getDeletePrefixMethod(), (Object)request, responseObserver);
            return;
        }
        KvResponse.Builder builder = KvResponse.newBuilder();
        try {
            String key = request.getKey();
            List kvs = this.kvService.deleteWithPrefix(key);
            WatchKv[] watchKvs = new WatchKv[kvs.size()];
            int i = 0;
            for (Kv kv : kvs) {
                WatchKv watchKV = this.getWatchKv(kv.getKey(), kv.getValue());
                watchKvs[i++] = watchKV;
            }
            this.subjects.notifyAllObserver(key, WatchType.Delete, watchKvs);
            response = builder.setHeader(this.getResponseHeader()).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getDeletePrefixMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void scanPrefix(K request, StreamObserver<ScanPrefixResponse> responseObserver) {
        ScanPrefixResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getScanPrefixMethod(), (Object)request, responseObserver);
            return;
        }
        ScanPrefixResponse.Builder builder = ScanPrefixResponse.newBuilder();
        try {
            Map kvs = this.kvService.scanWithPrefix(request.getKey());
            response = builder.setHeader(this.getResponseHeader()).putAllKvs(kvs).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getScanPrefixMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    private long getRandomLong() {
        long result;
        Random random = new Random();
        while ((result = random.nextLong()) == 0L) {
        }
        return result;
    }

    public void watch(WatchRequest request, StreamObserver<WatchResponse> responseObserver) {
        block6: {
            if (!this.isLeader()) {
                responseObserver.onError((Throwable)new PDException(-1, this.msg));
                return;
            }
            try {
                this.clientWatch(request, responseObserver, false);
            }
            catch (PDException e) {
                if (this.isLeader()) break block6;
                try {
                    responseObserver.onError((Throwable)new PDException(-1, this.msg));
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e1) {
                    log.error("redirect with error: ", (Throwable)e1);
                }
            }
        }
    }

    public void watchPrefix(WatchRequest request, StreamObserver<WatchResponse> responseObserver) {
        block6: {
            if (!this.isLeader()) {
                responseObserver.onError((Throwable)new PDException(-1, this.msg));
                return;
            }
            try {
                this.clientWatch(request, responseObserver, true);
            }
            catch (PDException e) {
                if (this.isLeader()) break block6;
                try {
                    responseObserver.onError((Throwable)new PDException(-1, this.msg));
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e1) {
                    log.error("redirect with error: ", (Throwable)e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientWatch(WatchRequest request, StreamObserver<WatchResponse> responseObserver, boolean isPrefix) throws PDException {
        try {
            WatchResponse response;
            String key = request.getKey();
            long clientId = request.getClientId();
            WatchResponse.Builder builder = WatchResponse.newBuilder();
            if (request.getState().equals((Object)WatchState.Starting) && clientId == 0L) {
                clientId = this.getRandomLong();
                response = builder.setClientId(clientId).setState(WatchState.Starting).build();
            } else {
                response = builder.setState(WatchState.Started).build();
            }
            String delimiter = isPrefix ? "PW" : "KW";
            this.subjects.addObserver(key, clientId, responseObserver, delimiter);
            StreamObserver<WatchResponse> streamObserver = responseObserver;
            synchronized (streamObserver) {
                responseObserver.onNext((Object)response);
            }
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                throw new PDException(-1, this.msg);
            }
            throw new PDException(e.getErrorCode(), (Throwable)e);
        }
    }

    public void lock(LockRequest request, StreamObserver<LockResponse> responseObserver) {
        LockResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getLockMethod(), (Object)request, responseObserver);
            return;
        }
        LockResponse.Builder builder = LockResponse.newBuilder();
        try {
            long clientId = request.getClientId();
            if (clientId == 0L) {
                clientId = this.getRandomLong();
            }
            boolean locked = this.kvService.lock(request.getKey(), request.getTtl(), clientId);
            response = builder.setHeader(this.getResponseHeader()).setSucceed(locked).setClientId(clientId).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getLockMethod(), (Object)request, responseObserver);
                return;
            }
            log.error("lock with error :", (Throwable)e);
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void lockWithoutReentrant(LockRequest request, StreamObserver<LockResponse> responseObserver) {
        LockResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getLockWithoutReentrantMethod(), (Object)request, responseObserver);
            return;
        }
        LockResponse.Builder builder = LockResponse.newBuilder();
        try {
            long clientId = request.getClientId();
            if (clientId == 0L) {
                clientId = this.getRandomLong();
            }
            boolean locked = this.kvService.lockWithoutReentrant(request.getKey(), request.getTtl(), clientId);
            response = builder.setHeader(this.getResponseHeader()).setSucceed(locked).setClientId(clientId).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getLockWithoutReentrantMethod(), (Object)request, responseObserver);
                return;
            }
            log.error("lock with error :", (Throwable)e);
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void isLocked(LockRequest request, StreamObserver<LockResponse> responseObserver) {
        LockResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getIsLockedMethod(), (Object)request, responseObserver);
            return;
        }
        LockResponse.Builder builder = LockResponse.newBuilder();
        try {
            boolean locked = this.kvService.locked(request.getKey());
            response = builder.setHeader(this.getResponseHeader()).setSucceed(locked).build();
        }
        catch (PDException e) {
            log.error("lock with error :", (Throwable)e);
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getIsLockedMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void unlock(LockRequest request, StreamObserver<LockResponse> responseObserver) {
        LockResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getUnlockMethod(), (Object)request, responseObserver);
            return;
        }
        LockResponse.Builder builder = LockResponse.newBuilder();
        try {
            long clientId = request.getClientId();
            if (clientId == 0L) {
                throw new PDException(-1, "incorrect clientId: 0");
            }
            boolean unlocked = this.kvService.unlock(request.getKey(), clientId);
            response = builder.setHeader(this.getResponseHeader()).setSucceed(unlocked).setClientId(clientId).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getUnlockMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void keepAlive(LockRequest request, StreamObserver<LockResponse> responseObserver) {
        LockResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getKeepAliveMethod(), (Object)request, responseObserver);
            return;
        }
        LockResponse.Builder builder = LockResponse.newBuilder();
        try {
            long clientId = request.getClientId();
            if (clientId == 0L) {
                throw new PDException(-1, "incorrect clientId: 0");
            }
            boolean alive = this.kvService.keepAlive(request.getKey(), clientId);
            response = builder.setHeader(this.getResponseHeader()).setSucceed(alive).setClientId(clientId).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getKeepAliveMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void putTTL(TTLRequest request, StreamObserver<TTLResponse> responseObserver) {
        TTLResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getPutTTLMethod(), (Object)request, responseObserver);
            return;
        }
        TTLResponse.Builder builder = TTLResponse.newBuilder();
        try {
            this.kvService.put(request.getKey(), request.getValue(), request.getTtl());
            response = builder.setHeader(this.getResponseHeader()).setSucceed(true).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getPutTTLMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void keepTTLAlive(TTLRequest request, StreamObserver<TTLResponse> responseObserver) {
        TTLResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(this.channel, KvServiceGrpc.getKeepTTLAliveMethod(), (Object)request, responseObserver);
            return;
        }
        TTLResponse.Builder builder = TTLResponse.newBuilder();
        try {
            this.kvService.keepAlive(request.getKey());
            response = builder.setHeader(this.getResponseHeader()).setSucceed(true).build();
        }
        catch (PDException e) {
            if (!this.isLeader()) {
                this.redirectToLeader(this.channel, KvServiceGrpc.getKeepTTLAliveMethod(), (Object)request, responseObserver);
                return;
            }
            response = builder.setHeader(this.getResponseHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    private WatchKv getWatchKv(String key, String value) {
        WatchKv kv = WatchKv.newBuilder().setKey(key).setValue(value).build();
        return kv;
    }

    public void onRaftLeaderChanged() {
        this.subjects.notifyClientChangeLeader();
    }
}

