/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.pd.RegistryService;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.grpc.pulse.ChangeShard;
import org.apache.hugegraph.pd.grpc.pulse.PartitionHeartbeatResponse;
import org.apache.hugegraph.pd.meta.MetadataFactory;
import org.apache.hugegraph.pd.meta.QueueStore;
import org.apache.hugegraph.pd.pulse.PDPulseSubject;
import org.apache.hugegraph.pd.watch.PDWatchSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestAPI {
    private static final Logger log = LoggerFactory.getLogger(TestAPI.class);
    @Autowired
    private PDConfig pdConfig;

    @GetMapping(value={"/discovery/{appName}"}, produces={"text/plain"})
    @ResponseBody
    public String discovery(@PathVariable(value="appName", required=true) String appName) {
        RegistryService register = new RegistryService(this.pdConfig);
        AtomicLong label = new AtomicLong();
        HashMap labels = new HashMap();
        String labelValue = String.valueOf(label.incrementAndGet());
        Query query = Query.newBuilder().build();
        return register.getNodes(query).toString();
    }

    @GetMapping(value={"/pulse"}, produces={"text/plain"})
    @ResponseBody
    public String notifyClient() {
        PDPulseSubject.notifyClient((PartitionHeartbeatResponse.Builder)PartitionHeartbeatResponse.newBuilder().setPartition(Metapb.Partition.newBuilder().setId(8).setGraphName("graphName8")).setChangeShard(ChangeShard.newBuilder().setChangeTypeValue(8).addShard(Metapb.Shard.newBuilder().setRoleValue(8).setStoreId(8L))));
        return "partition";
    }

    @GetMapping(value={"/partition"}, produces={"text/plain"})
    @ResponseBody
    public String noticePartition() {
        PDWatchSubject.notifyPartitionChange((PDWatchSubject.ChangeType)PDWatchSubject.ChangeType.ALTER, (String)"graph-test", (int)99);
        return "partition";
    }

    @PutMapping(value={"/queue"}, produces={"text/plain"})
    @ResponseBody
    public String testPutQueue() {
        this.putQueue();
        return "queue";
    }

    public void putQueue() {
        PartitionHeartbeatResponse response = PartitionHeartbeatResponse.newBuilder().setPartition(Metapb.Partition.newBuilder().setId(9).setGraphName("graphName")).setChangeShard(ChangeShard.newBuilder().setChangeTypeValue(9).addShard(Metapb.Shard.newBuilder().setRoleValue(9).setStoreId(9L))).build();
        Metapb.QueueItem.Builder builder = Metapb.QueueItem.newBuilder().setItemId("item-id").setItemClass("item-class").setItemContent(response.toByteString());
        QueueStore store = MetadataFactory.newQueueStore((PDConfig)this.pdConfig);
        try {
            store.addItem(builder.setItemId("item-id-1").build());
            store.addItem(builder.setItemId("item-id-2").build());
            store.addItem(builder.setItemId("item-id-3").build());
        }
        catch (PDException e2) {
            e2.printStackTrace();
        }
        List queue = null;
        try {
            queue = store.getQueue();
        }
        catch (PDException e3) {
            e3.printStackTrace();
        }
        Parser parser = PartitionHeartbeatResponse.parser();
        queue.stream().forEach(e -> {
            PartitionHeartbeatResponse buf = null;
            try {
                buf = (PartitionHeartbeatResponse)parser.parseFrom(e.getItemContent());
            }
            catch (InvalidProtocolBufferException ex) {
                ex.printStackTrace();
            }
            PDPulseSubject.notifyClient((PartitionHeartbeatResponse.Builder)PartitionHeartbeatResponse.newBuilder((PartitionHeartbeatResponse)buf));
        });
    }
}

