/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.google.protobuf.util.JsonFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.model.RestApiResponse;
import org.apache.hugegraph.pd.model.TimeRangeRequest;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.PartitionAPI;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class PartitionAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(PartitionAPI.class);
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    PDRestService pdRestService;

    @GetMapping(value={"/highLevelPartitions"}, produces={"application/json"})
    public RestApiResponse getHighLevelPartitions() {
        List stores;
        HashMap partitions2GraphsMap = new HashMap();
        HashMap<Integer, HighLevelPartition> resultPartitionsMap = new HashMap<Integer, HighLevelPartition>();
        HashMap<Integer, Long> partition2KeyCount = new HashMap<Integer, Long>();
        HashMap<Integer, Long> partition2DataSize = new HashMap<Integer, Long>();
        HashMap<Long, Object> storesMap = new HashMap<Long, Object>();
        try {
            stores = this.pdRestService.getStores("");
        }
        catch (PDException e) {
            log.error("getStores error", (Throwable)e);
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
        for (Object store : stores) {
            storesMap.put(store.getId(), store);
            List list = store.getStats().getGraphStatsList();
            for (Metapb.GraphStats graphStats : list) {
                if (Metapb.ShardRole.Leader != graphStats.getRole()) continue;
                partition2KeyCount.put(graphStats.getPartitionId(), partition2KeyCount.getOrDefault(graphStats.getPartitionId(), graphStats.getApproximateKeys()));
                partition2DataSize.put(graphStats.getPartitionId(), partition2DataSize.getOrDefault(graphStats.getPartitionId(), 0L) + graphStats.getApproximateSize());
                if (partitions2GraphsMap.get(graphStats.getPartitionId()) == null) {
                    partitions2GraphsMap.put(graphStats.getPartitionId(), new HashMap());
                }
                Map partitionGraphsMap = (Map)partitions2GraphsMap.get(graphStats.getPartitionId());
                partitionGraphsMap.put(graphStats.getGraphName(), new GraphStats(this, graphStats));
            }
        }
        List partitionList = this.pdRestService.getPartitions("");
        for (Metapb.Partition partition : partitionList) {
            Metapb.PartitionStats partitionStats;
            GraphStats graphStats;
            if (partitions2GraphsMap.get(partition.getId()) != null && (graphStats = (GraphStats)((Map)partitions2GraphsMap.get(partition.getId())).get(partition.getGraphName())) != null) {
                graphStats.startKey = partition.getStartKey();
                graphStats.endKey = partition.getEndKey();
            }
            if (resultPartitionsMap.get(partition.getId()) != null || partition.getGraphName().endsWith("/s")) continue;
            try {
                partitionStats = this.pdRestService.getPartitionStats(partition.getGraphName(), partition.getId());
            }
            catch (PDException e) {
                log.error("getPartitionStats error", (Throwable)e);
                partitionStats = null;
            }
            HighLevelPartition resultPartition = new HighLevelPartition(this, partition, partitionStats);
            resultPartition.keyCount = partition2KeyCount.getOrDefault(resultPartition.partitionId, 0L);
            resultPartition.dataSize = partition2DataSize.getOrDefault(resultPartition.partitionId, 0L);
            for (ShardStats shard : resultPartition.shards) {
                shard.address = ((Metapb.Store)storesMap.get(shard.storeId)).getAddress();
                shard.partitionId = partition.getId();
            }
            if (partitionStats != null && partitionStats.getLeader() != null) {
                long storeId = partitionStats.getLeader().getStoreId();
                resultPartition.leaderAddress = ((Metapb.Store)storesMap.get(storeId)).getAddress();
            }
            resultPartitionsMap.put(partition.getId(), resultPartition);
        }
        for (Map.Entry entry : resultPartitionsMap.entrySet()) {
            Integer partitionId = (Integer)entry.getKey();
            HighLevelPartition currentPartition = (HighLevelPartition)resultPartitionsMap.get(partitionId);
            Map graphsMap = partitions2GraphsMap.getOrDefault(partitionId, new HashMap());
            ArrayList<GraphStats> graphsList = new ArrayList<GraphStats>();
            for (Map.Entry entry1 : graphsMap.entrySet()) {
                if (!((String)entry1.getKey()).endsWith("/g")) continue;
                String graphName = (String)entry1.getKey();
                GraphStats tmpGraph = (GraphStats)graphsMap.get(graphName);
                int postfixLength = 2;
                tmpGraph.graphName = tmpGraph.graphName.substring(0, tmpGraph.graphName.length() - 2);
                graphsList.add(tmpGraph);
            }
            graphsList.sort((o1, o2) -> o1.graphName.compareTo(o2.graphName));
            currentPartition.graphs = graphsList;
        }
        ArrayList<HighLevelPartition> resultPartitionList = new ArrayList<HighLevelPartition>();
        if (!resultPartitionsMap.isEmpty()) {
            ArrayList arrayList = new ArrayList(resultPartitionsMap.keySet());
            arrayList.sort((o1, o2) -> o1 - o2);
            for (Integer partitionId : arrayList) {
                resultPartitionList.add((HighLevelPartition)resultPartitionsMap.get(partitionId));
            }
        }
        HashMap<String, ArrayList<HighLevelPartition>> hashMap = new HashMap<String, ArrayList<HighLevelPartition>>();
        hashMap.put("partitions", resultPartitionList);
        return new RestApiResponse(hashMap, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
    }

    @GetMapping(value={"/partitions"}, produces={"application/json"})
    public RestApiResponse getPartitions() {
        try {
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            List partitionList = this.pdRestService.getPartitions("");
            List stores = this.pdRestService.getStoreStats(false);
            HashMap raftMap = new HashMap();
            HashMap shardIndexMap = new HashMap();
            String delimiter = "@";
            for (int i = 0; i < stores.size(); ++i) {
                Metapb.Store store = (Metapb.Store)stores.get(i);
                Metapb.StoreStats storeStats = store.getStats();
                HashMap<Integer, Metapb.RaftStats> storeRaftStats = new HashMap<Integer, Metapb.RaftStats>();
                List raftStatsList = storeStats.getRaftStatsList();
                for (int j = 0; j < raftStatsList.size(); ++j) {
                    Metapb.RaftStats raftStats = (Metapb.RaftStats)raftStatsList.get(j);
                    storeRaftStats.put(raftStats.getPartitionId(), raftStats);
                }
                HashMap<String, Metapb.GraphStats> partitionShardStats = new HashMap<String, Metapb.GraphStats>();
                List graphStatsList = storeStats.getGraphStatsList();
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < graphStatsList.size(); ++j) {
                    Metapb.GraphStats graphStats = (Metapb.GraphStats)graphStatsList.get(j);
                    String graphName = graphStats.getGraphName();
                    String partitionId = Integer.toString(graphStats.getPartitionId());
                    builder.append(graphName).append(delimiter).append(partitionId);
                    partitionShardStats.put(builder.toString(), graphStats);
                    builder.setLength(0);
                }
                raftMap.put(store.getId(), storeRaftStats);
                shardIndexMap.put(store.getId(), partitionShardStats);
            }
            for (Metapb.Partition pt : partitionList) {
                Partition partition = new Partition(this, pt);
                String graphName = partition.getGraphName();
                partition.getShards().sort(Comparator.comparing(Shard::getStoreId));
                Metapb.PartitionStats partitionStats = this.pdRestService.getPartitionStats(graphName, pt.getId());
                Map shardStats = new HashMap();
                if (partitionStats != null) {
                    String dateTime = DateFormatUtils.format((long)partitionStats.getTimestamp(), (String)DEFAULT_DATETIME_FORMAT);
                    partition.setTimestamp(dateTime);
                    shardStats = this.getShardStats(partitionStats);
                }
                for (Metapb.Shard shard : this.pdRestService.getShardList(pt.getId())) {
                    Map finalShardStats = shardStats;
                    partition.getShards().add(new /* Unavailable Anonymous Inner Class!! */);
                }
                partition.setPartitionStats(partitionStats);
                partitions.add(partition);
            }
            partitions.sort(Comparator.comparing(Partition::getGraphName).thenComparing(Partition::getId));
            HashMap<String, ArrayList<Partition>> dataMap = new HashMap<String, ArrayList<Partition>>();
            dataMap.put("partitions", partitions);
            return new RestApiResponse(dataMap, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error("query metric data error", (Throwable)e);
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
    }

    @GetMapping(value={"/partitionsAndStats"}, produces={"application/json"})
    public String getPartitionsAndStats() {
        try {
            HashMap graph2Partitions = new HashMap();
            HashMap graph2PartitionStats = new HashMap();
            for (Metapb.Graph graph : this.pdRestService.getGraphs()) {
                ArrayList<Metapb.Partition> partitionList = new ArrayList<Metapb.Partition>();
                ArrayList<Metapb.PartitionStats> partitionStatsList = new ArrayList<Metapb.PartitionStats>();
                for (Metapb.Partition partition : this.pdRestService.getPartitions(graph.getGraphName())) {
                    Metapb.PartitionStats partitionStats = this.pdRestService.getPartitionStats(graph.getGraphName(), partition.getId());
                    partitionList.add(partition);
                    partitionStatsList.add(partitionStats);
                }
                graph2Partitions.put(graph.getGraphName(), partitionList);
                graph2PartitionStats.put(graph.getGraphName(), partitionStatsList);
            }
            String builder = "{\"partitions\":" + this.toJSON(graph2Partitions) + ",\"partitionStats\":" + this.toJSON(graph2PartitionStats) + "}";
            return builder;
        }
        catch (PDException e) {
            log.error("PD exception:" + e);
            return this.toJSON(e);
        }
    }

    private Map<Long, Metapb.ShardStats> getShardStats(Metapb.PartitionStats partitionStats) {
        HashMap<Long, Metapb.ShardStats> stats = new HashMap<Long, Metapb.ShardStats>();
        if (partitionStats.getShardStatsList() != null) {
            partitionStats.getShardStatsList().forEach(shardStats -> stats.put(shardStats.getStoreId(), (Metapb.ShardStats)shardStats));
        }
        return stats;
    }

    @PostMapping(value={"/partitions/log"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String getPartitionLog(@RequestBody TimeRangeRequest request) {
        try {
            Date dateStart = DateUtil.getDate((String)request.getStartTime());
            Date dateEnd = DateUtil.getDate((String)request.getEndTime());
            List changedRecords = this.pdRestService.getPartitionLog(Long.valueOf(dateStart.getTime()), Long.valueOf(dateEnd.getTime()));
            if (changedRecords != null) {
                JsonFormat.TypeRegistry registry = JsonFormat.TypeRegistry.newBuilder().add(Pdpb.SplitDataRequest.getDescriptor()).build();
                return this.toJSON(changedRecords, registry);
            }
            return this.toJSON(new PDException(103, "error"));
        }
        catch (PDException e) {
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/"}, produces={"application/json"})
    @ResponseBody
    public Statistics getStatistics() throws PDException, ExecutionException, InterruptedException {
        Statistics statistics = new Statistics(this);
        int partitionId = -1;
        return statistics;
    }
}

