/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.google.protobuf.MessageOrBuilder;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.model.GraphSpaceRestRequest;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.service.PDRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class GraphSpaceAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(GraphSpaceAPI.class);
    @Autowired
    PDRestService pdRestService;

    @GetMapping(value={"/graph-spaces"}, produces={"application/json"})
    @ResponseBody
    public String getGraphSpaces() {
        try {
            List graphSpaces = this.pdRestService.getGraphSpaces();
            return this.toJSON(graphSpaces, "graph-spaces");
        }
        catch (PDException e) {
            e.printStackTrace();
            return this.toJSON(e);
        }
    }

    @PostMapping(value={"/graph-spaces/**"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String setGraphSpace(@RequestBody GraphSpaceRestRequest body, HttpServletRequest request) {
        try {
            String requestURL = request.getRequestURL().toString();
            String graphSpaceName = requestURL.split("/graph-spaces/", 2)[1];
            graphSpaceName = URLDecoder.decode(graphSpaceName, StandardCharsets.UTF_8);
            Metapb.GraphSpace graphSpace = Metapb.GraphSpace.newBuilder().setName(graphSpaceName).setStorageLimit(body.getStorageLimit().longValue()).build();
            Metapb.GraphSpace newGraphSpace = this.pdRestService.setGraphSpace(graphSpace);
            return this.toJSON((MessageOrBuilder)newGraphSpace, "graph-spaces");
        }
        catch (PDException exception) {
            return this.toJSON(exception);
        }
        catch (Exception e) {
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/graph-spaces/**"}, produces={"application/json"})
    @ResponseBody
    public String getGraphSpace(HttpServletRequest request) {
        try {
            String requestURL = request.getRequestURL().toString();
            String graphSpaceName = requestURL.split("/graph-spaces/", 2)[1];
            graphSpaceName = URLDecoder.decode(graphSpaceName, StandardCharsets.UTF_8);
            Metapb.GraphSpace graphSpace = this.pdRestService.getGraphSpace(graphSpaceName);
            return this.toJSON((MessageOrBuilder)graphSpace, "graphs-paces");
        }
        catch (PDException exception) {
            return this.toJSON(exception);
        }
        catch (Exception e) {
            return this.toJSON(e);
        }
    }
}

