/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.variables;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;

public class HugeVariables
implements Graph.Variables {
    private static final Logger LOG = Log.logger(HugeVariables.class);
    private static final String VARIABLES = "variables";
    private static final String VARIABLE_KEY = "varKey";
    private static final String VARIABLE_TYPE = "varType";
    private static final String BYTE_VALUE = "B";
    private static final String BOOLEAN_VALUE = "Z";
    private static final String INTEGER_VALUE = "I";
    private static final String LONG_VALUE = "L";
    private static final String FLOAT_VALUE = "F";
    private static final String DOUBLE_VALUE = "D";
    private static final String STRING_VALUE = "S";
    private static final String LIST = "L";
    private static final String SET = "S";
    private static final String[] TYPES = new String[]{Graph.Hidden.hide((String)"B"), Graph.Hidden.hide((String)"Z"), Graph.Hidden.hide((String)"I"), Graph.Hidden.hide((String)"L"), Graph.Hidden.hide((String)"F"), Graph.Hidden.hide((String)"D"), Graph.Hidden.hide((String)"S"), Graph.Hidden.hide((String)"BL"), Graph.Hidden.hide((String)"ZL"), Graph.Hidden.hide((String)"IL"), Graph.Hidden.hide((String)"LL"), Graph.Hidden.hide((String)"FL"), Graph.Hidden.hide((String)"DL"), Graph.Hidden.hide((String)"SL"), Graph.Hidden.hide((String)"BS"), Graph.Hidden.hide((String)"ZS"), Graph.Hidden.hide((String)"IS"), Graph.Hidden.hide((String)"LS"), Graph.Hidden.hide((String)"FS"), Graph.Hidden.hide((String)"DS"), Graph.Hidden.hide((String)"SS")};
    private final HugeGraphParams params;

    public HugeVariables(HugeGraphParams params) {
        this.params = params;
    }

    public synchronized void initSchemaIfNeeded() {
        if (this.params.graph().existsVertexLabel(Graph.Hidden.hide((String)VARIABLES))) {
            return;
        }
        this.createPropertyKey(Graph.Hidden.hide((String)VARIABLE_KEY), DataType.TEXT, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)VARIABLE_TYPE), DataType.TEXT, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)BYTE_VALUE), DataType.BYTE, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)BOOLEAN_VALUE), DataType.BOOLEAN, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)INTEGER_VALUE), DataType.INT, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)"L"), DataType.LONG, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)FLOAT_VALUE), DataType.FLOAT, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)DOUBLE_VALUE), DataType.DOUBLE, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)"S"), DataType.TEXT, Cardinality.SINGLE);
        this.createPropertyKey(Graph.Hidden.hide((String)"BL"), DataType.BYTE, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"ZL"), DataType.BOOLEAN, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"IL"), DataType.INT, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"LL"), DataType.LONG, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"FL"), DataType.FLOAT, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"DL"), DataType.DOUBLE, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"SL"), DataType.TEXT, Cardinality.LIST);
        this.createPropertyKey(Graph.Hidden.hide((String)"BS"), DataType.BYTE, Cardinality.SET);
        this.createPropertyKey(Graph.Hidden.hide((String)"ZS"), DataType.BOOLEAN, Cardinality.SET);
        this.createPropertyKey(Graph.Hidden.hide((String)"IS"), DataType.INT, Cardinality.SET);
        this.createPropertyKey(Graph.Hidden.hide((String)"LS"), DataType.LONG, Cardinality.SET);
        this.createPropertyKey(Graph.Hidden.hide((String)"FS"), DataType.FLOAT, Cardinality.SET);
        this.createPropertyKey(Graph.Hidden.hide((String)"DS"), DataType.DOUBLE, Cardinality.SET);
        this.createPropertyKey(Graph.Hidden.hide((String)"SS"), DataType.TEXT, Cardinality.SET);
        Object[] properties = new String[]{Graph.Hidden.hide((String)VARIABLE_KEY), Graph.Hidden.hide((String)VARIABLE_TYPE)};
        properties = (String[])ArrayUtils.addAll((Object[])properties, (Object[])TYPES);
        SchemaManager schema = this.params.graph().schema();
        VertexLabel variables = (VertexLabel)schema.vertexLabel(Graph.Hidden.hide((String)VARIABLES)).properties((String[])properties).usePrimaryKeyId().primaryKeys(Graph.Hidden.hide((String)VARIABLE_KEY)).nullableKeys(TYPES).build();
        this.params.schemaTransaction().addVertexLabel(variables);
        LOG.debug("Variables schema created");
    }

    private void createPropertyKey(String name, DataType dataType, Cardinality cardinality) {
        SchemaManager schema = this.params.graph().schema();
        PropertyKey propertyKey = (PropertyKey)schema.propertyKey(name).dataType(dataType).cardinality(cardinality).build();
        this.params.schemaTransaction().addPropertyKey(propertyKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys() {
        Iterator<Vertex> vertices = this.queryAllVariableVertices();
        try {
            HashSet<String> keys = new HashSet<String>();
            while (vertices.hasNext()) {
                keys.add((String)vertices.next().value(Graph.Hidden.hide((String)VARIABLE_KEY)));
                Query.checkForceCapacity(keys.size());
            }
            HashSet<String> hashSet = keys;
            return hashSet;
        }
        finally {
            CloseableIterator.closeIterator(vertices);
        }
    }

    public <R> Optional<R> get(String key) {
        if (key == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        HugeVertex vertex = this.queryVariableVertex(key);
        if (vertex == null) {
            return Optional.empty();
        }
        String type = (String)vertex.value(Graph.Hidden.hide((String)VARIABLE_TYPE));
        if (!Arrays.asList(TYPES).contains(Graph.Hidden.hide((String)type))) {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)type);
        }
        return Optional.of(vertex.value(Graph.Hidden.hide((String)type)));
    }

    public void set(String key, Object value) {
        if (key == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        if (value == null) {
            throw Graph.Variables.Exceptions.variableValueCanNotBeNull();
        }
        this.createVariableVertex(key, value);
    }

    public void remove(String key) {
        if (key == null) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeNull();
        }
        if (key.isEmpty()) {
            throw Graph.Variables.Exceptions.variableKeyCanNotBeEmpty();
        }
        HugeVertex vertex = this.queryVariableVertex(key);
        if (vertex != null) {
            this.removeVariableVertex(vertex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> asMap() {
        Iterator<Vertex> vertices = this.queryAllVariableVertices();
        try {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            while (vertices.hasNext()) {
                Vertex vertex = vertices.next();
                String key = (String)vertex.value(Graph.Hidden.hide((String)VARIABLE_KEY));
                String type = (String)vertex.value(Graph.Hidden.hide((String)VARIABLE_TYPE));
                if (!Arrays.asList(TYPES).contains(Graph.Hidden.hide((String)type))) {
                    throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)type);
                }
                Object value = vertex.value(Graph.Hidden.hide((String)type));
                variables.put(key, value);
                Query.checkForceCapacity(variables.size());
            }
            Map<String, Object> map = Collections.unmodifiableMap(variables);
            return map;
        }
        finally {
            CloseableIterator.closeIterator(vertices);
        }
    }

    public String toString() {
        return StringFactory.graphVariablesString((Graph.Variables)this);
    }

    private void setProperty(HugeVertex vertex, String key, Object value) {
        String suffix = value instanceof List ? "L" : (value instanceof Set ? "S" : "");
        vertex.property(Graph.Hidden.hide((String)VARIABLE_KEY), key);
        Object object = HugeVariables.extractSingleObject(value);
        if (object == null) {
            vertex.property(Graph.Hidden.hide((String)("S" + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), "S" + suffix);
            return;
        }
        if (object instanceof Byte) {
            vertex.property(Graph.Hidden.hide((String)(BYTE_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), BYTE_VALUE + suffix);
        } else if (object instanceof Boolean) {
            vertex.property(Graph.Hidden.hide((String)(BOOLEAN_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), BOOLEAN_VALUE + suffix);
        } else if (object instanceof Integer) {
            vertex.property(Graph.Hidden.hide((String)(INTEGER_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), INTEGER_VALUE + suffix);
        } else if (object instanceof Long) {
            vertex.property(Graph.Hidden.hide((String)("L" + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), "L" + suffix);
        } else if (object instanceof Float) {
            vertex.property(Graph.Hidden.hide((String)(FLOAT_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), FLOAT_VALUE + suffix);
        } else if (object instanceof Double) {
            vertex.property(Graph.Hidden.hide((String)(DOUBLE_VALUE + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), DOUBLE_VALUE + suffix);
        } else if (object instanceof String) {
            vertex.property(Graph.Hidden.hide((String)("S" + suffix)), value);
            vertex.property(Graph.Hidden.hide((String)VARIABLE_TYPE), "S" + suffix);
        } else {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)value);
        }
    }

    private void createVariableVertex(String key, Object value) {
        VertexLabel vl = this.variableVertexLabel();
        GraphTransaction tx = this.params.graphTransaction();
        HugeVertex vertex = HugeVertex.create(tx, null, vl);
        try {
            this.setProperty(vertex, key, value);
        }
        catch (IllegalArgumentException e) {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)value, (Exception)e);
        }
        vertex.assignId(null);
        tx.addVertex(vertex);
    }

    private void removeVariableVertex(HugeVertex vertex) {
        this.params.graphTransaction().removeVertex(vertex);
    }

    private HugeVertex queryVariableVertex(String key) {
        GraphTransaction tx = this.params.graphTransaction();
        ConditionQuery query = this.createVariableQuery(key);
        Iterator<Vertex> vertices = tx.queryVertices(query);
        return (HugeVertex)QueryResults.one(vertices);
    }

    private Iterator<Vertex> queryAllVariableVertices() {
        GraphTransaction tx = this.params.graphTransaction();
        ConditionQuery query = this.createVariableQuery(null);
        Iterator<Vertex> vertices = tx.queryVertices(query);
        return vertices;
    }

    private ConditionQuery createVariableQuery(String name) {
        ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
        VertexLabel vl = this.variableVertexLabel();
        query.eq(HugeKeys.LABEL, vl.id());
        if (name != null) {
            PropertyKey pkey = this.params.graph().propertyKey(Graph.Hidden.hide((String)VARIABLE_KEY));
            query.query(Condition.eq(pkey.id(), (Object)name));
        }
        query.showHidden(true);
        return query;
    }

    private VertexLabel variableVertexLabel() {
        return this.params.graph().vertexLabel(Graph.Hidden.hide((String)VARIABLES));
    }

    private static Object extractSingleObject(Object value) {
        if (value instanceof List || value instanceof Set) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return null;
            }
            value = collection.iterator().next();
        }
        return value;
    }
}

