/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hugegraph.util.RateLimiter;

public class FixedWatchWindowRateLimiter
implements RateLimiter {
    private final LongAdder count;
    private final Stopwatch watch;
    private final int limit;

    public FixedWatchWindowRateLimiter(int limitPerSecond) {
        this.limit = limitPerSecond;
        this.watch = Stopwatch.createStarted();
        this.count = new LongAdder();
    }

    @Override
    public boolean tryAcquire() {
        if (this.count.intValue() < this.limit) {
            this.count.increment();
            return true;
        }
        if (this.watch.elapsed(TimeUnit.MILLISECONDS) >= 1000L) {
            this.count.reset();
            this.watch.reset();
            this.count.increment();
            return true;
        }
        return false;
    }
}

