/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.AbstractRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.Int2IntRecord;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.hugegraph.util.collection.IntIterator;
import org.apache.hugegraph.util.collection.IntMap;
import org.apache.hugegraph.util.collection.IntSet;

public abstract class SingleWayMultiPathsRecords
extends AbstractRecords {
    protected final int sourceCode;
    private final Stack<Record> records;
    private final boolean nearest;
    private final IntSet accessedVertices;
    private final HugeTraverser.EdgeRecord edgeResults;
    private IntIterator parentRecordKeys;

    public SingleWayMultiPathsRecords(RecordType type, boolean concurrent, Id source, boolean nearest) {
        super(type, concurrent);
        this.nearest = nearest;
        this.sourceCode = this.code(source);
        Record firstRecord = this.newRecord();
        firstRecord.addPath(this.sourceCode, 0);
        this.records = new Stack();
        this.records.push(firstRecord);
        this.edgeResults = new HugeTraverser.EdgeRecord(concurrent);
        this.accessedVertices = CollectionFactory.newIntSet();
    }

    @Override
    public void startOneLayer(boolean forward) {
        Record parentRecord = this.records.peek();
        this.currentRecord(this.newRecord(), parentRecord);
        this.parentRecordKeys = parentRecord.keys();
    }

    @Override
    public void finishOneLayer() {
        this.records.push(this.currentRecord());
    }

    @Override
    public boolean hasNextKey() {
        return this.parentRecordKeys.hasNext();
    }

    @Override
    public Id nextKey() {
        return this.id(this.parentRecordKeys.next());
    }

    @Override
    public HugeTraverser.PathSet findPath(Id target, Function<Id, Boolean> filter, boolean all, boolean ring) {
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        for (int i = 1; i < this.records.size(); ++i) {
            IntIterator iterator = ((Record)this.records.get(i)).keys();
            while (iterator.hasNext()) {
                paths.add(this.linkPath(i, iterator.next()));
            }
        }
        return paths;
    }

    @Override
    public long accessed() {
        return this.accessedVertices.size();
    }

    public Iterator<Id> keys() {
        return new IntIterator.MapperInt2ObjectIterator<Id>(this.parentRecordKeys, this::id);
    }

    @PerfUtil.Watched
    public void addPath(Id source, Id target) {
        this.addPathToRecord(this.code(source), this.code(target), this.currentRecord());
    }

    public void addPathToRecord(int sourceCode, int targetCode, Record record) {
        if (this.nearest && this.accessedVertices.contains(targetCode) || !this.nearest && record.containsKey(targetCode) || targetCode == this.sourceCode) {
            return;
        }
        record.addPath(targetCode, sourceCode);
        this.accessedVertices.add(targetCode);
    }

    protected final HugeTraverser.Path linkPath(int target) {
        IntMap layer;
        int i;
        List<Id> ids = CollectionFactory.newList(CollectionType.EC);
        int foundLayer = -1;
        for (i = 0; i < this.records.size(); ++i) {
            layer = this.layer(i);
            if (!layer.containsKey(target)) continue;
            foundLayer = i;
            ids.add(this.id(target));
            break;
        }
        if (foundLayer > 0) {
            for (i = foundLayer; i > 0; --i) {
                layer = this.layer(i);
                target = layer.get(target);
                ids.add(this.id(target));
            }
        }
        return new HugeTraverser.Path(ids);
    }

    protected final HugeTraverser.Path linkPath(int layerIndex, int target) {
        List<Id> ids = CollectionFactory.newList(CollectionType.EC);
        IntMap layer = this.layer(layerIndex);
        if (!layer.containsKey(target)) {
            throw new HugeException("Failed to get path for %s", this.id(target));
        }
        ids.add(this.id(target));
        for (int i = layerIndex; i > 0; --i) {
            layer = this.layer(i);
            target = layer.get(target);
            ids.add(this.id(target));
        }
        Collections.reverse(ids);
        return new HugeTraverser.Path(ids);
    }

    protected final IntMap layer(int layerIndex) {
        Record record = (Record)this.records.elementAt(layerIndex);
        return ((Int2IntRecord)record).layer();
    }

    protected final Stack<Record> records() {
        return this.records;
    }

    public HugeTraverser.EdgeRecord edgeResults() {
        return this.edgeResults;
    }

    public abstract int size();

    public abstract List<Id> ids(long var1);

    public abstract HugeTraverser.PathSet paths(long var1);
}

