/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.ShortestPathRecords;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ShortestPathTraverser
extends HugeTraverser {
    public ShortestPathTraverser(HugeGraph graph) {
        super(graph);
    }

    @PerfUtil.Watched
    public HugeTraverser.Path shortestPath(Id sourceV, Id targetV, Directions dir, List<String> labels, int depth, long degree, long skipDegree, long capacity) {
        HugeTraverser.PathSet paths;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        this.checkVertexExist(targetV, "target vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        ShortestPathTraverser.checkPositive(depth, "max depth");
        ShortestPathTraverser.checkDegree(degree);
        ShortestPathTraverser.checkCapacity(capacity);
        ShortestPathTraverser.checkSkipDegree(skipDegree, degree, capacity);
        if (sourceV.equals(targetV)) {
            return new HugeTraverser.Path((List<Id>)ImmutableList.of((Object)sourceV));
        }
        Map<Id, String> labelMap = ShortestPathTraverser.newMap(labels.size());
        for (String label : labels) {
            labelMap.put(this.getEdgeLabelIdOrNull(label), label);
        }
        Traverser traverser = new Traverser(sourceV, targetV, dir, labelMap, degree, skipDegree, capacity);
        while ((paths = traverser.forward(false)).isEmpty() && --depth > 0) {
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.accessed(), "shortest path");
            paths = traverser.backward(false);
            if (!paths.isEmpty() || --depth <= 0) break;
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.accessed(), "shortest path");
        }
        this.vertexIterCounter.addAndGet(traverser.vertexCount);
        this.edgeIterCounter.addAndGet(traverser.pathResults.accessed());
        HugeTraverser.Path path = paths.isEmpty() ? HugeTraverser.Path.EMPTY : paths.iterator().next();
        Set<Edge> edges = traverser.edgeResults.getEdges(path);
        path.setEdges(edges);
        return path;
    }

    public HugeTraverser.Path shortestPath(Id sourceV, Id targetV, EdgeStep step, int depth, long capacity) {
        return this.shortestPath(sourceV, targetV, step.direction(), ShortestPathTraverser.newList(step.labels().values()), depth, step.degree(), step.skipDegree(), capacity);
    }

    public HugeTraverser.PathSet allShortestPaths(Id sourceV, Id targetV, Directions dir, List<String> labels, int depth, long degree, long skipDegree, long capacity) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        E.checkNotNull((Object)targetV, (String)"target vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        this.checkVertexExist(targetV, "target vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        ShortestPathTraverser.checkPositive(depth, "max depth");
        ShortestPathTraverser.checkDegree(degree);
        ShortestPathTraverser.checkCapacity(capacity);
        ShortestPathTraverser.checkSkipDegree(skipDegree, degree, capacity);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        if (sourceV.equals(targetV)) {
            paths.add(new HugeTraverser.Path((List<Id>)ImmutableList.of((Object)sourceV)));
            return paths;
        }
        Map<Id, String> labelMap = ShortestPathTraverser.newMap(labels.size());
        for (String label : labels) {
            labelMap.put(this.getEdgeLabelIdOrNull(label), label);
        }
        Traverser traverser = new Traverser(sourceV, targetV, dir, labelMap, degree, skipDegree, capacity);
        while ((paths = traverser.traverse(true)).isEmpty() && --depth > 0) {
            ShortestPathTraverser.checkCapacity(traverser.capacity, traverser.accessed(), "shortest path");
        }
        this.vertexIterCounter.addAndGet(traverser.vertexCount);
        this.edgeIterCounter.addAndGet(traverser.pathResults.accessed());
        paths.setEdges(traverser.edgeResults.getEdges(paths));
        return paths;
    }

    private class Traverser {
        private final ShortestPathRecords pathResults;
        private final HugeTraverser.EdgeRecord edgeResults;
        private final Directions direction;
        private final Map<Id, String> labels;
        private final long degree;
        private final long skipDegree;
        private final long capacity;
        private long vertexCount;

        public Traverser(Id sourceV, Id targetV, Directions dir, Map<Id, String> labels, long degree, long skipDegree, long capacity) {
            this.pathResults = new ShortestPathRecords(sourceV, targetV);
            this.edgeResults = new HugeTraverser.EdgeRecord(false);
            this.direction = dir;
            this.labels = labels;
            this.degree = degree;
            this.skipDegree = skipDegree;
            this.capacity = capacity;
            this.vertexCount = 0L;
        }

        public HugeTraverser.PathSet traverse(boolean all) {
            return this.pathResults.sourcesLessThanTargets() ? this.forward(all) : this.backward(all);
        }

        @PerfUtil.Watched
        public HugeTraverser.PathSet forward(boolean all) {
            HugeTraverser.PathSet results = new HugeTraverser.PathSet();
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            this.pathResults.startOneLayer(true);
            while (this.pathResults.hasNextKey()) {
                Id source = this.pathResults.nextKey();
                Iterator<Edge> edges = ShortestPathTraverser.this.edgesOfVertex(source, this.direction, this.labels, degree);
                edges = HugeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
                ++this.vertexCount;
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    this.edgeResults.addEdge(source, target, edge);
                    HugeTraverser.PathSet paths = this.pathResults.findPath(target, t -> !this.superNode((Id)t, this.direction), all, false);
                    if (paths.isEmpty()) continue;
                    results.addAll(paths);
                    if (all) continue;
                    return paths;
                }
            }
            this.pathResults.finishOneLayer();
            return results;
        }

        @PerfUtil.Watched
        public HugeTraverser.PathSet backward(boolean all) {
            HugeTraverser.PathSet results = new HugeTraverser.PathSet();
            long degree = this.skipDegree > 0L ? this.skipDegree : this.degree;
            Directions opposite = this.direction.opposite();
            this.pathResults.startOneLayer(false);
            while (this.pathResults.hasNextKey()) {
                Id source = this.pathResults.nextKey();
                Iterator<Edge> edges = ShortestPathTraverser.this.edgesOfVertex(source, opposite, this.labels, degree);
                edges = HugeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
                ++this.vertexCount;
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    this.edgeResults.addEdge(source, target, edge);
                    HugeTraverser.PathSet paths = this.pathResults.findPath(target, t -> !this.superNode((Id)t, opposite), all, false);
                    if (paths.isEmpty()) continue;
                    results.addAll(paths);
                    if (all) continue;
                    return results;
                }
            }
            this.pathResults.finishOneLayer();
            return results;
        }

        private boolean superNode(Id vertex, Directions direction) {
            if (this.skipDegree <= 0L) {
                return false;
            }
            Iterator<Edge> edges = ShortestPathTraverser.this.edgesOfVertex(vertex, direction, this.labels, this.skipDegree);
            return IteratorUtils.count(edges) >= this.skipDegree;
        }

        private long accessed() {
            return this.pathResults.accessed();
        }
    }
}

