/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.iterator.ListIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.masterelection.GlobalMasterInfo;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeServerInfo;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.type.define.NodeRole;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class ServerInfoManager {
    private static final Logger LOG = Log.logger(ServerInfoManager.class);
    public static final long MAX_SERVERS = 100000L;
    public static final long PAGE_SIZE = 10L;
    private final HugeGraphParams graph;
    private final ExecutorService dbExecutor;
    private volatile GlobalMasterInfo globalNodeInfo;
    private volatile boolean onlySingleNode;
    private volatile boolean closed;

    public ServerInfoManager(HugeGraphParams graph, ExecutorService dbExecutor) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)dbExecutor, (String)"db executor");
        this.graph = graph;
        this.dbExecutor = dbExecutor;
        this.globalNodeInfo = null;
        this.onlySingleNode = false;
        this.closed = false;
    }

    public void init() {
        HugeServerInfo.schema(this.graph).initSchemaIfNeeded();
    }

    public synchronized boolean close() {
        this.closed = true;
        if (!this.dbExecutor.isShutdown()) {
            this.removeSelfServerInfo();
            this.call(() -> {
                try {
                    this.tx().close();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                this.graph.closeTx();
                return null;
            });
        }
        return true;
    }

    public synchronized void initServerInfo(GlobalMasterInfo nodeInfo) {
        E.checkArgument((nodeInfo != null ? 1 : 0) != 0, (String)"The global node info can't be null", (Object[])new Object[0]);
        Id serverId = nodeInfo.nodeId();
        HugeServerInfo existed = this.serverInfo(serverId);
        if (existed != null && existed.alive()) {
            long now = DateUtil.now().getTime();
            if (existed.expireTime() > now + 30000L) {
                LOG.info("The node time maybe skew very much: {}", (Object)existed);
                throw new HugeException("The server with name '%s' maybe skew very much", serverId);
            }
            try {
                Thread.sleep(existed.expireTime() - now + 1L);
            }
            catch (InterruptedException e) {
                throw new HugeException("Interrupted when waiting for server info expired", e);
            }
        }
        E.checkArgument((existed == null || !existed.alive() ? 1 : 0) != 0, (String)"The server with name '%s' already in cluster", (Object[])new Object[]{serverId});
        if (nodeInfo.nodeRole().master()) {
            String page = this.supportsPaging() ? "" : null;
            do {
                Iterator<HugeServerInfo> servers = this.serverInfos(10L, page);
                while (servers.hasNext()) {
                    existed = servers.next();
                    E.checkArgument((!existed.role().master() || !existed.alive() ? 1 : 0) != 0, (String)"Already existed master '%s' in current cluster", (Object[])new Object[]{existed.id()});
                }
                if (page == null) continue;
                page = PageInfo.pageInfo(servers);
            } while (page != null);
        }
        this.globalNodeInfo = nodeInfo;
        this.saveServerInfo(this.selfNodeId(), this.selfNodeRole());
    }

    public synchronized void changeServerRole(NodeRole nodeRole) {
        if (this.closed) {
            return;
        }
        this.globalNodeInfo.changeNodeRole(nodeRole);
        this.saveServerInfo(this.selfNodeId(), this.selfNodeRole());
    }

    public GlobalMasterInfo globalNodeRoleInfo() {
        return this.globalNodeInfo;
    }

    public Id selfNodeId() {
        if (this.globalNodeInfo == null) {
            return null;
        }
        return this.globalNodeInfo.nodeId();
    }

    public NodeRole selfNodeRole() {
        if (this.globalNodeInfo == null) {
            return null;
        }
        return this.globalNodeInfo.nodeRole();
    }

    public boolean selfIsMaster() {
        return this.selfNodeRole() != null && this.selfNodeRole().master();
    }

    public boolean onlySingleNode() {
        return this.onlySingleNode;
    }

    public synchronized void heartbeat() {
        assert (this.graphIsReady());
        HugeServerInfo serverInfo = this.selfServerInfo();
        if (serverInfo != null) {
            serverInfo.updateTime(DateUtil.now());
            this.save(serverInfo);
            return;
        }
        if (this.selfNodeId() == null) {
            LOG.info("ServerInfo is missing: {}, may not be initialized yet", (Object)this.selfNodeId());
            return;
        }
        if (this.selfIsMaster()) {
            LOG.warn("ServerInfo is missing: {}, may be cleared before", (Object)this.selfNodeId());
            return;
        }
        serverInfo = this.saveServerInfo(this.selfNodeId(), this.selfNodeRole());
        assert (serverInfo != null);
    }

    public synchronized void decreaseLoad(int load) {
        assert (load > 0) : load;
        HugeServerInfo serverInfo = this.selfServerInfo();
        serverInfo.increaseLoad(-load);
        this.save(serverInfo);
    }

    public int calcMaxLoad() {
        return 10000;
    }

    protected boolean graphIsReady() {
        return !this.closed && this.graph.started() && this.graph.initialized();
    }

    protected synchronized HugeServerInfo pickWorkerNode(Collection<HugeServerInfo> servers, HugeTask<?> task) {
        boolean singleNode;
        HugeServerInfo master = null;
        HugeServerInfo serverWithMinLoad = null;
        int minLoad = Integer.MAX_VALUE;
        boolean hasWorkerNode = false;
        long now = DateUtil.now().getTime();
        for (HugeServerInfo server : servers) {
            if (!server.alive()) continue;
            if (server.role().master()) {
                master = server;
                continue;
            }
            hasWorkerNode = true;
            if (!server.suitableFor(task, now) || server.load() >= minLoad) continue;
            minLoad = server.load();
            serverWithMinLoad = server;
        }
        boolean bl = singleNode = !hasWorkerNode;
        if (singleNode != this.onlySingleNode) {
            LOG.info("Switch only_single_node to {}", (Object)singleNode);
            this.onlySingleNode = singleNode;
        }
        if (!hasWorkerNode && master != null && master.suitableFor(task, now)) {
            serverWithMinLoad = master;
        }
        return serverWithMinLoad;
    }

    private GraphTransaction tx() {
        assert (Thread.currentThread().getName().contains("server-info-db-worker"));
        return this.graph.systemTransaction();
    }

    private HugeServerInfo saveServerInfo(Id serverId, NodeRole serverRole) {
        HugeServerInfo serverInfo = new HugeServerInfo(serverId, serverRole);
        serverInfo.maxLoad(this.calcMaxLoad());
        this.save(serverInfo);
        LOG.info("Init server info: {}", (Object)serverInfo);
        return serverInfo;
    }

    private Id save(HugeServerInfo serverInfo) {
        return this.call(() -> {
            HugeServerInfo.Schema schema = HugeServerInfo.schema(this.graph);
            if (!schema.existVertexLabel(HugeServerInfo.P.SERVER)) {
                throw new HugeException("Schema is missing for %s '%s'", HugeServerInfo.P.SERVER, serverInfo);
            }
            HugeVertex vertex = this.tx().constructVertex(false, serverInfo.asArray());
            vertex = this.tx().addVertex(vertex);
            return vertex.id();
        });
    }

    private int save(Collection<HugeServerInfo> serverInfos) {
        return this.call(() -> {
            if (serverInfos.isEmpty()) {
                return 0;
            }
            HugeServerInfo.Schema schema = HugeServerInfo.schema(this.graph);
            if (!schema.existVertexLabel(HugeServerInfo.P.SERVER)) {
                throw new HugeException("Schema is missing for %s", HugeServerInfo.P.SERVER);
            }
            GraphTransaction tx = this.tx();
            int updated = 0;
            for (HugeServerInfo server : serverInfos) {
                if (!server.updated()) continue;
                HugeVertex vertex = tx.constructVertex(false, server.asArray());
                tx.addVertex(vertex);
                ++updated;
            }
            tx.commitOrRollback();
            return updated;
        });
    }

    private <V> V call(Callable<V> callable) {
        assert (!Thread.currentThread().getName().startsWith("server-info-db-worker")) : "can't call by itself";
        try {
            callable = new TaskManager.ContextCallable<V>(callable);
            return this.dbExecutor.submit(callable).get();
        }
        catch (Throwable e) {
            throw new HugeException("Failed to update/query server info: %s", e, e.toString());
        }
    }

    private HugeServerInfo selfServerInfo() {
        HugeServerInfo selfServerInfo = this.serverInfo(this.selfNodeId());
        if (selfServerInfo == null && this.selfNodeId() != null) {
            LOG.warn("ServerInfo is missing: {}", (Object)this.selfNodeId());
        }
        return selfServerInfo;
    }

    private HugeServerInfo serverInfo(Id serverId) {
        return this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryServerInfos(serverId);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            return HugeServerInfo.fromVertex(vertex);
        });
    }

    private HugeServerInfo removeSelfServerInfo() {
        if (this.selfNodeId() != null && this.graph.initialized()) {
            return this.removeServerInfo(this.selfNodeId());
        }
        return null;
    }

    private HugeServerInfo removeServerInfo(Id serverId) {
        if (serverId == null) {
            return null;
        }
        LOG.info("Remove server info: {}", (Object)serverId);
        return this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryServerInfos(serverId);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            this.tx().removeVertex((HugeVertex)vertex);
            return HugeServerInfo.fromVertex(vertex);
        });
    }

    protected void updateServerInfos(Collection<HugeServerInfo> serverInfos) {
        this.save(serverInfos);
    }

    protected Collection<HugeServerInfo> allServerInfos() {
        Collection collection;
        Iterator<HugeServerInfo> infos = this.serverInfos(Long.MAX_VALUE, null);
        ListIterator iter = new ListIterator(100000L, infos);
        try {
            collection = iter.list();
        }
        catch (Throwable throwable) {
            try {
                try {
                    iter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new HugeException("Failed to close server info iterator", e);
            }
        }
        iter.close();
        return collection;
    }

    protected Iterator<HugeServerInfo> serverInfos(String page) {
        return this.serverInfos((Map<String, Object>)ImmutableMap.of(), 10L, page);
    }

    protected Iterator<HugeServerInfo> serverInfos(long limit, String page) {
        return this.serverInfos((Map<String, Object>)ImmutableMap.of(), limit, page);
    }

    private Iterator<HugeServerInfo> serverInfos(Map<String, Object> conditions, long limit, String page) {
        return (Iterator)this.call(() -> {
            ConditionQuery query = this.graph.backendStoreFeatures().supportsTaskAndServerVertex() ? new ConditionQuery(HugeType.SERVER) : new ConditionQuery(HugeType.VERTEX);
            if (page != null) {
                query.page(page);
            }
            HugeGraph graph = this.graph.graph();
            VertexLabel vl = graph.vertexLabel(HugeServerInfo.P.SERVER);
            query.eq(HugeKeys.LABEL, vl.id());
            for (Map.Entry entry : conditions.entrySet()) {
                PropertyKey pk = graph.propertyKey((String)entry.getKey());
                query.query(Condition.eq(pk.id(), entry.getValue()));
            }
            query.showHidden(true);
            if (limit != Long.MAX_VALUE) {
                query.limit(limit);
            }
            Iterator<Vertex> vertices = this.tx().queryServerInfos(query);
            MapperIterator servers = new MapperIterator(vertices, HugeServerInfo::fromVertex);
            return QueryResults.toList(servers);
        });
    }

    private boolean supportsPaging() {
        return this.graph.graph().backendStoreFeatures().supportsQueryByPage();
    }
}

