/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.collection.CollectionFactory;

public class GraphMetaManager
extends AbstractMetaManager {
    public GraphMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    private static String graphName(String graphSpace, String name) {
        return String.join((CharSequence)"-", graphSpace, name);
    }

    public Map<String, Map<String, Object>> graphConfigs(String graphSpace) {
        Map<String, Map<String, Object>> configs = CollectionFactory.newMap(CollectionType.EC);
        Map<String, String> keyValues = this.metaDriver.scanWithPrefix(this.graphConfPrefix(graphSpace));
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            String key = entry.getKey();
            String[] parts = key.split("/");
            String name = parts[parts.length - 1];
            String graphName = String.join((CharSequence)"-", graphSpace, name);
            configs.put(graphName, GraphMetaManager.configMap(entry.getValue()));
        }
        return configs;
    }

    public void removeGraphConfig(String graphSpace, String graph) {
        this.metaDriver.delete(this.graphConfKey(graphSpace, graph));
    }

    public void notifyGraphAdd(String graphSpace, String graph) {
        this.metaDriver.put(this.graphAddKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifyGraphRemove(String graphSpace, String graph) {
        this.metaDriver.put(this.graphRemoveKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifyGraphUpdate(String graphSpace, String graph) {
        this.metaDriver.put(this.graphUpdateKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifyGraphClear(String graphSpace, String graph) {
        this.metaDriver.put(this.graphClearKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifySchemaCacheClear(String graphSpace, String graph) {
        this.metaDriver.put(this.schemaCacheClearKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifyGraphCacheClear(String graphSpace, String graph) {
        this.metaDriver.put(this.graphCacheClearKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifyGraphVertexCacheClear(String graphSpace, String graph) {
        this.metaDriver.put(this.graphVertexCacheClearKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public void notifyGraphEdgeCacheClear(String graphSpace, String graph) {
        this.metaDriver.put(this.graphEdgeCacheClearKey(), GraphMetaManager.graphName(graphSpace, graph));
    }

    public Map<String, Object> getGraphConfig(String graphSpace, String graph) {
        return GraphMetaManager.configMap(this.metaDriver.get(this.graphConfKey(graphSpace, graph)));
    }

    public void addGraphConfig(String graphSpace, String graph, Map<String, Object> configs) {
        this.metaDriver.put(this.graphConfKey(graphSpace, graph), JsonUtil.toJson(configs));
    }

    public void updateGraphConfig(String graphSpace, String graph, Map<String, Object> configs) {
        this.metaDriver.put(this.graphConfKey(graphSpace, graph), JsonUtil.toJson(configs));
    }

    public <T> void listenGraphAdd(Consumer<T> consumer) {
        this.listen(this.graphAddKey(), consumer);
    }

    public <T> void listenGraphUpdate(Consumer<T> consumer) {
        this.listen(this.graphUpdateKey(), consumer);
    }

    public <T> void listenGraphRemove(Consumer<T> consumer) {
        this.listen(this.graphRemoveKey(), consumer);
    }

    public <T> void listenGraphClear(Consumer<T> consumer) {
        this.listen(this.graphClearKey(), consumer);
    }

    public <T> void listenSchemaCacheClear(Consumer<T> consumer) {
        this.listen(this.schemaCacheClearKey(), consumer);
    }

    public <T> void listenGraphCacheClear(Consumer<T> consumer) {
        this.listen(this.graphCacheClearKey(), consumer);
    }

    public <T> void listenGraphVertexCacheClear(Consumer<T> consumer) {
        this.listen(this.graphVertexCacheClearKey(), consumer);
    }

    public <T> void listenGraphEdgeCacheClear(Consumer<T> consumer) {
        this.listen(this.graphEdgeCacheClearKey(), consumer);
    }

    private String graphConfPrefix(String graphSpace) {
        return this.graphConfKey(graphSpace, "");
    }

    private String graphConfKey(String graphSpace, String graph) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "GRAPH_CONF", graph);
    }

    private String graphAddKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "ADD");
    }

    private String graphRemoveKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "REMOVE");
    }

    private String graphUpdateKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "UPDATE");
    }

    private String graphClearKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "CLEAR");
    }

    private String schemaCacheClearKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "SCHEMA", "CLEAR");
    }

    private String graphCacheClearKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "GRAPH", "CLEAR");
    }

    private String graphVertexCacheClearKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "GRAPH", "VERTEX_LABEL", "CLEAR");
    }

    private String graphEdgeCacheClearKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "GRAPH", "GRAPH", "EDGE_LABEL", "CLEAR");
    }
}

