/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.util.JsonUtil;

public class ConfigMetaManager
extends AbstractMetaManager {
    public ConfigMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    public Map<String, Object> restProperties(String graphSpace, String serviceId) {
        Map map = null;
        String result = this.metaDriver.get(this.restPropertiesKey(graphSpace, serviceId));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            map = JsonUtil.fromJson(result, Map.class);
        }
        return map;
    }

    public Map<String, Object> restProperties(String graphSpace, String serviceId, Map<String, Object> properties) {
        Map map;
        String result = this.metaDriver.get(this.restPropertiesKey(graphSpace, serviceId));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            map = JsonUtil.fromJson(result, Map.class);
            for (Map.Entry item : properties.entrySet()) {
                map.put((String)item.getKey(), item.getValue());
            }
        } else {
            map = properties;
        }
        this.metaDriver.put(this.restPropertiesKey(graphSpace, serviceId), JsonUtil.toJson(map));
        return map;
    }

    public Map<String, Object> deleteRestProperties(String graphSpace, String serviceId, String key) {
        Map map = null;
        String result = this.metaDriver.get(this.restPropertiesKey(graphSpace, serviceId));
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            map = JsonUtil.fromJson(result, Map.class);
            map.remove(key);
            this.metaDriver.put(this.restPropertiesKey(graphSpace, serviceId), JsonUtil.toJson(map));
        }
        return map;
    }

    public Map<String, Object> clearRestProperties(String graphSpace, String serviceId) {
        Map map = null;
        String key = this.restPropertiesKey(graphSpace, serviceId);
        String result = this.metaDriver.get(key);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            map = JsonUtil.fromJson(result, Map.class);
            this.metaDriver.delete(key);
        }
        return map;
    }

    public String gremlinYaml(String graphSpace, String serviceId) {
        return this.metaDriver.get(this.gremlinYamlKey(graphSpace, serviceId));
    }

    public String gremlinYaml(String graphSpace, String serviceId, String yaml) {
        this.metaDriver.put(this.gremlinYamlKey(graphSpace, serviceId), yaml);
        return yaml;
    }

    public <T> void listenRestPropertiesUpdate(String graphSpace, String serviceId, Consumer<T> consumer) {
        this.listen(this.restPropertiesKey(graphSpace, serviceId), consumer);
    }

    public <T> void listenGremlinYamlUpdate(String graphSpace, String serviceId, Consumer<T> consumer) {
        this.listen(this.gremlinYamlKey(graphSpace, serviceId), consumer);
    }

    private String restPropertiesKey(String graphSpace, String serviceId) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "SERVICE", serviceId, "REST_PROPERTIES");
    }

    private String gremlinYamlKey(String graphSpace, String serviceId) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "SERVICE", serviceId, "GREMLIN_YAML");
    }
}

