/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.lock;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.pd.client.KvClient;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.kv.LockResponse;

public class PdDistributedLock {
    private static final int poolSize = 8;
    private final KvClient<?> client;
    private final ScheduledExecutorService service = new ScheduledThreadPoolExecutor(8, r -> {
        Thread t = new Thread(r, "keepalive");
        t.setDaemon(true);
        return t;
    });

    public PdDistributedLock(KvClient<?> client) {
        this.client = client;
    }

    public LockResult lock(String key, long second) {
        long ttl = second * 1000L;
        try {
            LockResponse response = this.client.lockWithoutReentrant(key, ttl);
            boolean succeed = response.getSucceed();
            LockResult result = new LockResult();
            if (succeed) {
                result.setLeaseId(response.getClientId());
                result.lockSuccess(true);
                long period = ttl - ttl / 4L;
                ScheduledFuture<?> future = this.service.scheduleAtFixedRate(() -> {
                    LockResult lockResult = result;
                    synchronized (lockResult) {
                        this.keepAlive(key);
                    }
                }, period, period, TimeUnit.MILLISECONDS);
                result.setFuture(future);
            }
            return result;
        }
        catch (PDException e) {
            throw new HugeException("Failed to lock '%s' to pd", (Throwable)e, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLock(String key, LockResult lockResult) {
        block6: {
            try {
                LockResponse response = this.client.unlock(key);
                boolean succeed = response.getSucceed();
                if (!succeed) {
                    throw new HugeException("Failed to unlock '%s' to pd", key);
                }
                if (lockResult.getFuture() == null) break block6;
                LockResult lockResult2 = lockResult;
                synchronized (lockResult2) {
                    lockResult.getFuture().cancel(true);
                }
            }
            catch (PDException e) {
                throw new HugeException("Failed to unlock '%s' to pd", (Throwable)e, key);
            }
        }
    }

    public boolean keepAlive(String key) {
        try {
            LockResponse alive = this.client.keepAlive(key);
            return alive.getSucceed();
        }
        catch (PDException e) {
            throw new HugeException("Failed to keepAlive '%s' to pd", key);
        }
    }
}

