/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.system;

import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.job.EphemeralJob;
import org.apache.hugegraph.job.EphemeralJobBuilder;
import org.apache.hugegraph.job.system.DeleteExpiredElementJob;
import org.apache.hugegraph.job.system.DeleteExpiredIndexJob;
import org.apache.hugegraph.job.system.JobCounters;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class DeleteExpiredJob<T>
extends EphemeralJob<T> {
    protected static final Logger LOG = Log.logger(DeleteExpiredJob.class);
    private static final int MAX_JOBS = 1000;
    protected static final JobCounters JOB_COUNTERS = new JobCounters();

    public static <V> void asyncDeleteExpiredObject(HugeGraph graph, V object) {
        HugeTask task;
        E.checkArgumentNotNull(object, (String)"The object can't be null", (Object[])new Object[0]);
        JobCounters.JobCounter jobCounter = JOB_COUNTERS.jobCounter(graph);
        if (!jobCounter.addAndTriggerDelete(object)) {
            return;
        }
        if (jobCounter.jobs() >= 1000) {
            LOG.debug("Pending delete expired objects jobs size {} has reached the limit {}, abandon {}", new Object[]{jobCounter.jobs(), 1000, object});
            return;
        }
        jobCounter.increment();
        EphemeralJob<V> job = DeleteExpiredJob.newDeleteExpiredElementJob(jobCounter, object);
        jobCounter.clear(object);
        try {
            task = EphemeralJobBuilder.of(graph).name("delete_expired_object").job(job).schedule();
        }
        catch (Throwable e) {
            jobCounter.decrement();
            if (e.getMessage().contains("Pending tasks size") && e.getMessage().contains("has exceeded the max limit")) {
                return;
            }
            throw e;
        }
        if (((Boolean)graph.option(CoreOptions.TASK_SYNC_DELETION)).booleanValue()) {
            task.syncWait();
        }
    }

    public static <V> EphemeralJob<V> newDeleteExpiredElementJob(JobCounters.JobCounter jobCounter, V object) {
        if (object instanceof HugeElement) {
            return new DeleteExpiredElementJob(jobCounter.elements());
        }
        assert (object instanceof HugeIndex);
        return new DeleteExpiredIndexJob(jobCounter.indexes());
    }
}

