/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.schema;

import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.job.schema.SchemaJob;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.LockUtil;

public class IndexLabelRemoveJob
extends SchemaJob {
    @Override
    public String type() {
        return "remove_schema";
    }

    @Override
    public Object execute() {
        IndexLabelRemoveJob.removeIndexLabel(this.params(), this.schemaId());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeIndexLabel(HugeGraphParams graph, Id id) {
        GraphTransaction graphTx = graph.graphTransaction();
        ISchemaTransaction schemaTx = graph.schemaTransaction();
        IndexLabel indexLabel = schemaTx.getIndexLabel(id);
        if (indexLabel == null) {
            return;
        }
        if (indexLabel.status().deleting()) {
            LOG.info("The index label '{}' has been in {} status, please check if it's expected to delete it again", (Object)indexLabel, (Object)indexLabel.status());
        }
        LockUtil.Locks locks = new LockUtil.Locks(graph.name());
        try {
            locks.lockWrites("il_delete", id);
            schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.DELETING);
            try {
                schemaTx.removeIndexLabelFromBaseLabel(indexLabel);
                graphTx.removeIndex(indexLabel);
                graph.graph().tx().commit();
                IndexLabelRemoveJob.removeSchema(schemaTx, indexLabel);
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(indexLabel, SchemaStatus.UNDELETED);
                throw e;
            }
        }
        finally {
            locks.unlock();
        }
    }
}

