/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.computer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hugegraph.job.computer.AbstractComputer;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ParameterUtil;

public class LpaComputer
extends AbstractComputer {
    public static final String LPA = "lpa";
    public static final String PROPERTY = "property";
    public static final String DEFAULT_PROPERTY = "id";

    @Override
    public String name() {
        return LPA;
    }

    @Override
    public String category() {
        return "community";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        LpaComputer.times(parameters);
        LpaComputer.property(parameters);
        LpaComputer.precision(parameters);
        LpaComputer.direction(parameters);
        LpaComputer.degree(parameters);
    }

    @Override
    protected Map<String, Object> checkAndCollectParameters(Map<String, Object> parameters) {
        return ImmutableMap.of((Object)"times", (Object)LpaComputer.times(parameters), (Object)PROPERTY, (Object)LpaComputer.property(parameters), (Object)"precision", (Object)LpaComputer.precision(parameters), (Object)"direction", (Object)LpaComputer.direction(parameters), (Object)"degree", (Object)LpaComputer.degree(parameters));
    }

    private static String property(Map<String, Object> parameters) {
        if (!parameters.containsKey(PROPERTY)) {
            return DEFAULT_PROPERTY;
        }
        String property = ParameterUtil.parameterString(parameters, PROPERTY);
        E.checkArgument((property != null && !property.isEmpty() ? 1 : 0) != 0, (String)"The value of %s can not be null or empty", (Object[])new Object[]{PROPERTY});
        return property;
    }
}

