/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.traversal.algorithm.FusiformSimilarityTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.ParameterUtil;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class KCoreAlgorithm
extends AbstractCommAlgorithm {
    public static final String ALGO_NAME = "k_core";
    public static final String KEY_K = "k";
    public static final String KEY_MERGED = "merged";
    public static final int DEFAULT_K = 3;

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        KCoreAlgorithm.k(parameters);
        KCoreAlgorithm.alpha(parameters);
        KCoreAlgorithm.merged(parameters);
        KCoreAlgorithm.degree(parameters);
        KCoreAlgorithm.sourceLabel(parameters);
        KCoreAlgorithm.sourceCLabel(parameters);
        KCoreAlgorithm.direction(parameters);
        KCoreAlgorithm.edgeLabel(parameters);
        KCoreAlgorithm.workers(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        int workers = KCoreAlgorithm.workers(parameters);
        try (Traverser traverser = new Traverser(job, workers);){
            Object object = traverser.kcore(KCoreAlgorithm.sourceLabel(parameters), KCoreAlgorithm.sourceCLabel(parameters), KCoreAlgorithm.direction(parameters), KCoreAlgorithm.edgeLabel(parameters), KCoreAlgorithm.k(parameters), KCoreAlgorithm.alpha(parameters), KCoreAlgorithm.degree(parameters), KCoreAlgorithm.merged(parameters));
            return object;
        }
    }

    protected static int k(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_K)) {
            return 3;
        }
        int k = ParameterUtil.parameterInt(parameters, KEY_K);
        E.checkArgument((k > 1 ? 1 : 0) != 0, (String)"The k of kcore must be > 1, but got %s", (Object[])new Object[]{k});
        return k;
    }

    protected static boolean merged(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_MERGED)) {
            return false;
        }
        return ParameterUtil.parameterBoolean(parameters, KEY_MERGED);
    }

    private static class KcoreSimilar
    extends FusiformSimilarityTraverser.Similar {
        private Set<Id> ids;

        public KcoreSimilar(Id id, double score, List<Id> intermediaries) {
            super(id, score, intermediaries);
            this.ids = null;
        }

        public KcoreSimilar(FusiformSimilarityTraverser.Similar similar) {
            super(similar.id(), similar.score(), similar.intermediaries());
            this.ids = new HashSet<Id>(this.intermediaries());
        }

        public Set<Id> ids() {
            if (this.ids == null) {
                this.ids = new HashSet<Id>(this.intermediaries());
            }
            return this.ids;
        }

        public void ids(Set<Id> ids) {
            this.ids = ids;
        }
    }

    public static class KcoreTraverser
    extends FusiformSimilarityTraverser {
        public KcoreTraverser(HugeGraph graph) {
            super(graph);
        }

        public Set<Id> kcore(Iterator<Vertex> vertices, Directions direction, String label, int k, double alpha, long degree) {
            int minNeighbors = (int)Math.floor(1.0 / alpha * (double)k);
            FusiformSimilarityTraverser.SimilarsMap map = this.fusiformSimilarity(vertices, direction, label, minNeighbors, alpha, k - 1, 0, null, 0, degree, -1L, -1L, true);
            if (map.isEmpty()) {
                return ImmutableSet.of();
            }
            return KcoreTraverser.extractKcore(map, k);
        }

        private static Set<Id> extractKcore(FusiformSimilarityTraverser.SimilarsMap similarsMap, int k) {
            boolean stop;
            assert (similarsMap.size() == 1);
            Map.Entry<Id, Set<FusiformSimilarityTraverser.Similar>> entry = similarsMap.entrySet().iterator().next();
            Id source = entry.getKey();
            HashSet<KcoreSimilar> similars = new HashSet<KcoreSimilar>();
            for (FusiformSimilarityTraverser.Similar similar : entry.getValue()) {
                similars.add(new KcoreSimilar(similar));
            }
            do {
                stop = true;
                HashMap<Id, Object> counts = new HashMap<Id, Object>();
                for (KcoreSimilar kcoreSimilar : similars) {
                    for (Id id : kcoreSimilar.ids()) {
                        Object count = (MutableInt)counts.get(id);
                        if (count == null) {
                            count = new MutableInt(0);
                            counts.put(id, count);
                        }
                        count.increment();
                    }
                }
                HashSet<KcoreSimilar> failedSimilars = new HashSet<KcoreSimilar>();
                for (KcoreSimilar similar3 : similars) {
                    HashSet<Id> failedIds = new HashSet<Id>();
                    for (Id id : similar3.ids()) {
                        MutableInt count = (MutableInt)counts.get(id);
                        if (count.getValue() >= k - 1) continue;
                        count.decrement();
                        failedIds.add(id);
                        stop = false;
                    }
                    HashSet<Id> survivedIds = new HashSet<Id>(CollectionUtils.subtract(similar3.ids(), failedIds));
                    if (survivedIds.size() < k) {
                        for (Id id : survivedIds) {
                            ((MutableInt)counts.get(id)).decrement();
                        }
                        failedSimilars.add(similar3);
                        continue;
                    }
                    similar3.ids(survivedIds);
                }
                similars = new HashSet(CollectionUtils.subtract(similars, failedSimilars));
            } while (!stop);
            if (similars.isEmpty()) {
                return ImmutableSet.of();
            }
            HashSet<Id> kcores = new HashSet<Id>();
            kcores.add(source);
            for (KcoreSimilar kcoreSimilar : similars) {
                kcores.add(kcoreSimilar.id());
                kcores.addAll(kcoreSimilar.ids());
            }
            return kcores;
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job, int workers) {
            super(job, KCoreAlgorithm.ALGO_NAME, workers);
        }

        public Object kcore(String sourceLabel, String sourceCLabel, Directions dir, String label, int k, double alpha, long degree, boolean merged) {
            HugeGraph graph = this.graph();
            KcoreTraverser traverser = new KcoreTraverser(graph);
            AbstractAlgorithm.JsonMap kcoresJson = new AbstractAlgorithm.JsonMap();
            kcoresJson.startObject();
            kcoresJson.appendKey("kcores");
            kcoresJson.startList();
            HashSet kcores = new HashSet();
            this.traverse(sourceLabel, sourceCLabel, v -> {
                Set<Id> kcore = traverser.kcore(IteratorUtils.of((Object)v), dir, label, k, alpha, degree);
                if (kcore.isEmpty()) {
                    return;
                }
                if (merged) {
                    Set set = kcores;
                    synchronized (set) {
                        Traverser.mergeKcores(kcores, kcore);
                    }
                }
                String json = JsonUtil.toJson(kcore);
                AbstractAlgorithm.JsonMap jsonMap = kcoresJson;
                synchronized (jsonMap) {
                    kcoresJson.appendRaw(json);
                }
            });
            if (merged) {
                for (Set kcore : kcores) {
                    kcoresJson.appendRaw(JsonUtil.toJson(kcore));
                }
            }
            kcoresJson.endList();
            kcoresJson.endObject();
            return kcoresJson.asJson();
        }

        private static void mergeKcores(Set<Set<Id>> kcores, Set<Id> kcore) {
            boolean merged = false;
            HashSet<Set<Id>> mergingKcores = new HashSet<Set<Id>>();
            for (Set<Id> existedKcore : kcores) {
                if (!CollectionUtil.hasIntersection(existedKcore, kcore)) continue;
                mergingKcores.add(existedKcore);
                merged = true;
            }
            if (merged) {
                for (Set<Id> mergingKcore : mergingKcores) {
                    kcores.remove(mergingKcore);
                    kcore.addAll(mergingKcore);
                }
            }
            kcores.add(kcore);
        }
    }
}

