/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import java.util.Map;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.TriangleCountAlgorithm;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class ClusterCoefficientAlgorithm
extends AbstractCommAlgorithm {
    public static final String ALGO_NAME = "cluster_coefficient";

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        ClusterCoefficientAlgorithm.direction(parameters);
        ClusterCoefficientAlgorithm.degree(parameters);
        ClusterCoefficientAlgorithm.workersWhenBoth(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        int workers = ClusterCoefficientAlgorithm.workersWhenBoth(parameters);
        try (Traverser traverser = new Traverser(job, workers);){
            Object object = traverser.clusterCoefficient(ClusterCoefficientAlgorithm.direction(parameters), ClusterCoefficientAlgorithm.degree(parameters));
            return object;
        }
    }

    protected static int workersWhenBoth(Map<String, Object> parameters) {
        Directions direction = ClusterCoefficientAlgorithm.direction(parameters);
        int workers = ClusterCoefficientAlgorithm.workers(parameters);
        E.checkArgument((direction == Directions.BOTH || workers <= 0 ? 1 : 0) != 0, (String)"The workers must be not set when direction!=BOTH, but got workers=%s and direction=%s", (Object[])new Object[]{workers, direction});
        return workers;
    }

    private static class Traverser
    extends TriangleCountAlgorithm.Traverser {
        public Traverser(UserJob<Object> job, int workers) {
            super(job, ClusterCoefficientAlgorithm.ALGO_NAME, workers);
        }

        public Object clusterCoefficient(Directions direction, long degree) {
            Map results = this.triangles(direction, degree);
            results = InsertionOrderUtil.newMap(results);
            long triangles = (Long)results.remove("triangles");
            long triads = (Long)results.remove("triads");
            assert (triangles <= triads);
            double coefficient = triads == 0L ? 0.0 : 1.0 * (double)triangles / (double)triads;
            Map converted = results;
            converted.put(ClusterCoefficientAlgorithm.ALGO_NAME, coefficient);
            return results;
        }
    }
}

