/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import java.security.SecureRandom;
import java.util.Base64;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class AuthOptions
extends OptionHolder {
    private static volatile AuthOptions instance;
    public static final ConfigOption<String> AUTHENTICATOR;
    public static final ConfigOption<String> AUTH_GRAPH_STORE;
    public static final ConfigOption<String> AUTH_ADMIN_TOKEN;
    public static final ConfigListOption<String> AUTH_USER_TOKENS;
    public static final ConfigOption<String> AUTH_REMOTE_URL;
    public static final ConfigOption<String> AUTH_TOKEN_SECRET;
    public static final ConfigOption<Double> AUTH_AUDIT_LOG_RATE;
    public static final ConfigOption<Long> AUTH_CACHE_EXPIRE;
    public static final ConfigOption<Long> AUTH_CACHE_CAPACITY;
    public static final ConfigOption<Long> AUTH_TOKEN_EXPIRE;

    private AuthOptions() {
    }

    public static synchronized AuthOptions instance() {
        if (instance == null) {
            instance = new AuthOptions();
            instance.registerOptions();
        }
        return instance;
    }

    private static String generateRandomBase64Key() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    static {
        AUTHENTICATOR = new ConfigOption("auth.authenticator", "The class path of authenticator implementation. e.g., org.apache.hugegraph.auth.StandardAuthenticator, or org.apache.hugegraph.auth.ConfigAuthenticator.", null, (Object)"");
        AUTH_GRAPH_STORE = new ConfigOption("auth.graph_store", "The name of graph used to store authentication information, like users, only for org.apache.hugegraph.auth.StandardAuthenticator.", OptionChecker.disallowEmpty(), (Object)"hugegraph");
        AUTH_ADMIN_TOKEN = new ConfigOption("auth.admin_token", "Token for administrator operations, only for org.apache.hugegraph.auth.ConfigAuthenticator.", OptionChecker.disallowEmpty(), (Object)"162f7848-0b6d-4faf-b557-3a0797869c55");
        AUTH_USER_TOKENS = new ConfigListOption("auth.user_tokens", "The map of user tokens with name and password, only for org.apache.hugegraph.auth.ConfigAuthenticator.", OptionChecker.disallowEmpty(), (Object[])new String[]{"hugegraph:9fd95c9c-711b-415b-b85f-d4df46ba5c31"});
        AUTH_REMOTE_URL = new ConfigOption("auth.remote_url", "If the address is empty, it provide auth service, otherwise it is auth client and also provide auth service through rpc forwarding. The remote url can be set to multiple addresses, which are concat by ','.", null, (Object)"");
        AUTH_TOKEN_SECRET = new ConfigOption("auth.token_secret", "Secret key of HS256 algorithm.", OptionChecker.disallowEmpty(), (Object)AuthOptions.generateRandomBase64Key());
        AUTH_AUDIT_LOG_RATE = new ConfigOption("auth.audit_log_rate", "The max rate of audit log output per user, default value is 1000 records per second.", OptionChecker.rangeDouble((Number)0.0, (Number)Double.MAX_VALUE), (Object)1000.0);
        AUTH_CACHE_EXPIRE = new ConfigOption("auth.cache_expire", "The expiration time in seconds of auth cache in auth client and auth server.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)600L);
        AUTH_CACHE_CAPACITY = new ConfigOption("auth.cache_capacity", "The max cache capacity of each auth cache item.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10240L);
        AUTH_TOKEN_EXPIRE = new ConfigOption("auth.token_expire", "The expiration time in seconds after token created", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)86400L);
    }
}

