/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.tx;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.backend.tx.IdCounter;
import org.apache.hugegraph.backend.tx.SchemaTransaction;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.exception.NotAllowException;
import org.apache.hugegraph.job.JobBuilder;
import org.apache.hugegraph.job.schema.EdgeLabelRemoveJob;
import org.apache.hugegraph.job.schema.IndexLabelRebuildJob;
import org.apache.hugegraph.job.schema.IndexLabelRemoveJob;
import org.apache.hugegraph.job.schema.OlapPropertyKeyClearJob;
import org.apache.hugegraph.job.schema.OlapPropertyKeyCreateJob;
import org.apache.hugegraph.job.schema.OlapPropertyKeyRemoveJob;
import org.apache.hugegraph.job.schema.SchemaJob;
import org.apache.hugegraph.job.schema.VertexLabelRemoveJob;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.MetaManager;
import org.apache.hugegraph.meta.PdMetaDriver;
import org.apache.hugegraph.meta.managers.SchemaMetaManager;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.type.define.WriteType;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LockUtil;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

public class SchemaTransactionV2
implements ISchemaTransaction {
    protected static final Logger LOG = Log.logger(SchemaTransaction.class);
    private final String graphSpace;
    private final String graph;
    private final HugeGraphParams graphParams;
    private final IdCounter idCounter;
    private final SchemaMetaManager schemaMetaManager;

    public SchemaTransactionV2(MetaDriver metaDriver, String cluster, HugeGraphParams graphParams) {
        E.checkNotNull((Object)graphParams, (String)"graphParams");
        this.graphParams = graphParams;
        this.graphSpace = "";
        this.graph = graphParams.name();
        this.schemaMetaManager = new SchemaMetaManager(metaDriver, cluster, this.graph());
        this.idCounter = new IdCounter(((PdMetaDriver)metaDriver).pdClient(), this.idKeyName(this.graphSpace, this.graph));
    }

    private static void setCreateTimeIfNeeded(SchemaElement schema) {
        if (!schema.userdata().containsKey("~create_time")) {
            schema.userdata("~create_time", DateUtil.now());
        }
    }

    private static Id asyncRun(HugeGraph graph, SchemaElement schema, SchemaJob job) {
        return SchemaTransactionV2.asyncRun(graph, schema, job, (Set<Id>)ImmutableSet.of());
    }

    @PerfUtil.Watched(prefix="schema")
    private static Id asyncRun(HugeGraph graph, SchemaElement schema, SchemaJob job, Set<Id> dependencies) {
        E.checkArgument((schema != null ? 1 : 0) != 0, (String)"Schema can't be null", (Object[])new Object[0]);
        String name = SchemaJob.formatTaskName(schema.type(), schema.id(), schema.name());
        JobBuilder<Object> builder = JobBuilder.of(graph).name(name).job(job).dependencies(dependencies);
        HugeTask<Object> task = builder.schedule();
        if (((Boolean)graph.option(CoreOptions.TASK_SYNC_DELETION)).booleanValue()) {
            task.syncWait();
        }
        return task.id();
    }

    public String idKeyName(String graphSpace, String graph) {
        return String.join((CharSequence)"/", graphSpace, graph, "m");
    }

    @PerfUtil.Watched(prefix="schema")
    public List<PropertyKey> getPropertyKeys(boolean cache) {
        return this.getAllSchema(HugeType.PROPERTY_KEY);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public List<PropertyKey> getPropertyKeys() {
        return this.getAllSchema(HugeType.PROPERTY_KEY);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public List<VertexLabel> getVertexLabels() {
        return this.getAllSchema(HugeType.VERTEX_LABEL);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public List<EdgeLabel> getEdgeLabels() {
        return this.getAllSchema(HugeType.EDGE_LABEL);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public List<IndexLabel> getIndexLabels() {
        return this.getAllSchema(HugeType.INDEX_LABEL);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id addPropertyKey(PropertyKey propertyKey) {
        this.addSchema(propertyKey);
        if (!propertyKey.olap()) {
            return IdGenerator.ZERO;
        }
        return this.createOlapPk(propertyKey);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void updatePropertyKey(PropertyKey propertyKey) {
        this.updateSchema(propertyKey, null);
    }

    public void updatePropertyKey(PropertyKey old, PropertyKey update) {
        this.removePropertyKey(old.id());
        this.addPropertyKey(update);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public PropertyKey getPropertyKey(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Property key id can't be null", (Object[])new Object[0]);
        return (PropertyKey)this.getSchema(HugeType.PROPERTY_KEY, id);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public PropertyKey getPropertyKey(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Property key name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Property key name can't be empty", (Object[])new Object[0]);
        return (PropertyKey)this.getSchema(HugeType.PROPERTY_KEY, name);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id removePropertyKey(Id id) {
        LOG.debug("SchemaTransaction remove property key '{}'", (Object)id);
        PropertyKey propertyKey = this.getPropertyKey(id);
        if (propertyKey == null) {
            return null;
        }
        List<VertexLabel> vertexLabels = this.getVertexLabels();
        for (VertexLabel vertexLabel : vertexLabels) {
            if (!vertexLabel.properties().contains(id)) continue;
            throw new NotAllowException("Not allowed to remove property key: '%s' because the vertex label '%s' is still using it.", propertyKey, vertexLabel.name());
        }
        List<EdgeLabel> edgeLabels = this.getEdgeLabels();
        for (EdgeLabel edgeLabel : edgeLabels) {
            if (!edgeLabel.properties().contains(id)) continue;
            throw new NotAllowException("Not allowed to remove property key: '%s' because the edge label '%s' is still using it.", propertyKey, edgeLabel.name());
        }
        if (propertyKey.oltp()) {
            this.removeSchema(propertyKey);
            return IdGenerator.ZERO;
        }
        return this.removeOlapPk(propertyKey);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void addVertexLabel(VertexLabel vertexLabel) {
        this.addSchema(vertexLabel);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void updateVertexLabel(VertexLabel vertexLabel) {
        this.updateSchema(vertexLabel, null);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public VertexLabel getVertexLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Vertex label id can't be null", (Object[])new Object[0]);
        if (SchemaElement.OLAP_ID.equals(id)) {
            return VertexLabel.OLAP_VL;
        }
        return (VertexLabel)this.getSchema(HugeType.VERTEX_LABEL, id);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public VertexLabel getVertexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Vertex label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Vertex label name can't be empty", (Object[])new Object[0]);
        if ("~olap".equals(name)) {
            return VertexLabel.OLAP_VL;
        }
        return (VertexLabel)this.getSchema(HugeType.VERTEX_LABEL, name);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id removeVertexLabel(Id id) {
        LOG.debug("SchemaTransaction remove vertex label '{}'", (Object)id);
        VertexLabelRemoveJob job = new VertexLabelRemoveJob();
        VertexLabel schema = this.getVertexLabel(id);
        return SchemaTransactionV2.asyncRun(this.graph(), schema, job);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void addEdgeLabel(EdgeLabel edgeLabel) {
        this.addSchema(edgeLabel);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void updateEdgeLabel(EdgeLabel edgeLabel) {
        this.updateSchema(edgeLabel, null);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public EdgeLabel getEdgeLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Edge label id can't be null", (Object[])new Object[0]);
        return (EdgeLabel)this.getSchema(HugeType.EDGE_LABEL, id);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public EdgeLabel getEdgeLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Edge label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Edge label name can't be empty", (Object[])new Object[0]);
        return (EdgeLabel)this.getSchema(HugeType.EDGE_LABEL, name);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id removeEdgeLabel(Id id) {
        LOG.debug("SchemaTransaction remove edge label '{}'", (Object)id);
        EdgeLabel schema = this.getEdgeLabel(id);
        if (schema.edgeLabelType().parent()) {
            List<EdgeLabel> edgeLabels = this.getEdgeLabels();
            for (EdgeLabel edgeLabel : edgeLabels) {
                if (!edgeLabel.edgeLabelType().sub() || edgeLabel.fatherId() != id) continue;
                throw new NotAllowException("Not allowed to remove a parent edge label: '%s' because the sub edge label '%s' is still existing", schema.name(), edgeLabel.name());
            }
        }
        EdgeLabelRemoveJob job = new EdgeLabelRemoveJob();
        return SchemaTransactionV2.asyncRun(this.graph(), schema, job);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void addIndexLabel(SchemaLabel baseLabel, IndexLabel indexLabel) {
        this.addSchema(indexLabel);
        if (baseLabel.equals(VertexLabel.OLAP_VL)) {
            return;
        }
        this.updateSchema(baseLabel, schema -> baseLabel.addIndexLabel(indexLabel.id()));
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void updateIndexLabel(IndexLabel indexLabel) {
        this.updateSchema(indexLabel, null);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public IndexLabel getIndexLabel(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Index label id can't be null", (Object[])new Object[0]);
        return (IndexLabel)this.getSchema(HugeType.INDEX_LABEL, id);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public IndexLabel getIndexLabel(String name) {
        E.checkArgumentNotNull((Object)name, (String)"Index label name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Index label name can't be empty", (Object[])new Object[0]);
        return (IndexLabel)this.getSchema(HugeType.INDEX_LABEL, name);
    }

    @Override
    public void close() {
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id removeIndexLabel(Id id) {
        LOG.debug("SchemaTransaction remove index label '{}'", (Object)id);
        IndexLabelRemoveJob job = new IndexLabelRemoveJob();
        IndexLabel schema = this.getIndexLabel(id);
        return SchemaTransactionV2.asyncRun(this.graph(), schema, job);
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public void updateSchemaStatus(SchemaElement schema, SchemaStatus status) {
        if (!this.existsSchemaId(schema.type(), schema.id())) {
            LOG.warn("Can't update schema '{}', it may be deleted", (Object)schema);
            return;
        }
        this.updateSchema(schema, schemaToUpdate -> schema.status(status));
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public boolean existsSchemaId(HugeType type, Id id) {
        return this.getSchema(type, id) != null;
    }

    @Override
    public void removeIndexLabelFromBaseLabel(IndexLabel indexLabel) {
        SchemaLabel baseLabel;
        HugeType baseType = indexLabel.baseType();
        Id baseValue = indexLabel.baseValue();
        if (baseType == HugeType.VERTEX_LABEL) {
            baseLabel = this.getVertexLabel(baseValue);
        } else {
            assert (baseType == HugeType.EDGE_LABEL);
            baseLabel = this.getEdgeLabel(baseValue);
        }
        if (baseLabel == null) {
            LOG.info("The base label '{}' of index label '{}' may be deleted before", (Object)baseValue, (Object)indexLabel);
            return;
        }
        if (baseLabel.equals(VertexLabel.OLAP_VL)) {
            return;
        }
        this.updateSchema(baseLabel, schema -> baseLabel.removeIndexLabel(indexLabel.id()));
    }

    protected void updateSchema(SchemaElement schema, Consumer<SchemaElement> updateCallback) {
        LOG.debug("SchemaTransaction update {} with id '{}'", (Object)schema.type(), (Object)schema.id());
        this.saveSchema(schema, true, updateCallback);
    }

    protected void addSchema(SchemaElement schema) {
        LOG.debug("SchemaTransaction add {} with id '{}'", (Object)schema.type(), (Object)schema.id());
        SchemaTransactionV2.setCreateTimeIfNeeded(schema);
        this.saveSchema(schema, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSchema(SchemaElement schema, boolean update, Consumer<SchemaElement> updateCallback) {
        LockUtil.Locks locks = new LockUtil.Locks(this.graph);
        try {
            locks.lockWrites(LockUtil.hugeType2Group(schema.type()), schema.id());
            if (updateCallback != null) {
                updateCallback.accept(schema);
            }
            switch (schema.type()) {
                case PROPERTY_KEY: {
                    this.schemaMetaManager.addPropertyKey(this.graphSpace, this.graph, (PropertyKey)schema);
                    return;
                }
                case VERTEX_LABEL: {
                    this.schemaMetaManager.addVertexLabel(this.graphSpace, this.graph, (VertexLabel)schema);
                    MetaManager.instance().notifyGraphVertexCacheClear(this.graphSpace, this.graph);
                    return;
                }
                case EDGE_LABEL: {
                    this.schemaMetaManager.addEdgeLabel(this.graphSpace, this.graph, (EdgeLabel)schema);
                    MetaManager.instance().notifyGraphEdgeCacheClear(this.graphSpace, this.graph);
                    return;
                }
                case INDEX_LABEL: {
                    this.schemaMetaManager.addIndexLabel(this.graphSpace, this.graph, (IndexLabel)schema);
                    return;
                }
                default: {
                    throw new AssertionError((Object)String.format("Invalid key '%s' for saveSchema", schema.type()));
                }
            }
        }
        finally {
            locks.unlock();
        }
    }

    protected <T extends SchemaElement> T getSchema(HugeType type, Id id) {
        LOG.debug("SchemaTransaction get {} by id '{}'", (Object)type.readableName(), (Object)id);
        switch (type) {
            case PROPERTY_KEY: {
                return (T)this.schemaMetaManager.getPropertyKey(this.graphSpace, this.graph, id);
            }
            case VERTEX_LABEL: {
                return (T)this.schemaMetaManager.getVertexLabel(this.graphSpace, this.graph, id);
            }
            case EDGE_LABEL: {
                return (T)this.schemaMetaManager.getEdgeLabel(this.graphSpace, this.graph, id);
            }
            case INDEX_LABEL: {
                return (T)this.schemaMetaManager.getIndexLabel(this.graphSpace, this.graph, id);
            }
        }
        throw new AssertionError((Object)String.format("Invalid type '%s' for getSchema", type));
    }

    protected <T extends SchemaElement> T getSchema(HugeType type, String name) {
        LOG.debug("SchemaTransaction get {} by name '{}'", (Object)type.readableName(), (Object)name);
        switch (type) {
            case PROPERTY_KEY: {
                return (T)this.schemaMetaManager.getPropertyKey(this.graphSpace, this.graph, name);
            }
            case VERTEX_LABEL: {
                return (T)this.schemaMetaManager.getVertexLabel(this.graphSpace, this.graph, name);
            }
            case EDGE_LABEL: {
                return (T)this.schemaMetaManager.getEdgeLabel(this.graphSpace, this.graph, name);
            }
            case INDEX_LABEL: {
                return (T)this.schemaMetaManager.getIndexLabel(this.graphSpace, this.graph, name);
            }
        }
        throw new AssertionError((Object)String.format("Invalid type '%s' for getSchema", type));
    }

    protected <T extends SchemaElement> List<T> getAllSchema(HugeType type) {
        LOG.debug("SchemaTransaction getAllSchema {}", (Object)type.readableName());
        switch (type) {
            case PROPERTY_KEY: {
                return this.schemaMetaManager.getPropertyKeys(this.graphSpace, this.graph);
            }
            case VERTEX_LABEL: {
                return this.schemaMetaManager.getVertexLabels(this.graphSpace, this.graph);
            }
            case EDGE_LABEL: {
                return this.schemaMetaManager.getEdgeLabels(this.graphSpace, this.graph);
            }
            case INDEX_LABEL: {
                return this.schemaMetaManager.getIndexLabels(this.graphSpace, this.graph);
            }
        }
        throw new AssertionError((Object)String.format("Invalid type '%s' for getSchema", type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeSchema(SchemaElement schema) {
        LOG.debug("SchemaTransaction remove {} by id '{}'", (Object)schema.type(), (Object)schema.id());
        LockUtil.Locks locks = new LockUtil.Locks(this.graph);
        try {
            locks.lockWrites(LockUtil.hugeType2Group(schema.type()), schema.id());
            switch (schema.type()) {
                case PROPERTY_KEY: {
                    this.schemaMetaManager.removePropertyKey(this.graphSpace, this.graph, schema.id());
                    return;
                }
                case VERTEX_LABEL: {
                    this.schemaMetaManager.removeVertexLabel(this.graphSpace, this.graph, schema.id());
                    return;
                }
                case EDGE_LABEL: {
                    this.schemaMetaManager.removeEdgeLabel(this.graphSpace, this.graph, schema.id());
                    return;
                }
                case INDEX_LABEL: {
                    this.schemaMetaManager.removeIndexLabel(this.graphSpace, this.graph, schema.id());
                    return;
                }
                default: {
                    throw new AssertionError((Object)String.format("Invalid key '%s' for saveSchema", schema.type()));
                }
            }
        }
        finally {
            locks.unlock();
        }
    }

    @Override
    public void createIndexLabelForOlapPk(PropertyKey propertyKey) {
        WriteType writeType = propertyKey.writeType();
        if (writeType == WriteType.OLTP || writeType == WriteType.OLAP_COMMON) {
            return;
        }
        String indexName = "~olap_by_" + propertyKey.name();
        IndexLabel.Builder builder = this.graph().schema().indexLabel(indexName).onV("~olap").by(propertyKey.name());
        if (propertyKey.writeType() == WriteType.OLAP_SECONDARY) {
            builder.secondary();
        } else {
            assert (propertyKey.writeType() == WriteType.OLAP_RANGE);
            builder.range();
        }
        builder.build();
        this.graph().addIndexLabel(VertexLabel.OLAP_VL, (IndexLabel)builder.build());
    }

    public Id removeOlapPk(PropertyKey propertyKey) {
        LOG.debug("SchemaTransaction remove olap property key {} with id '{}'", (Object)propertyKey.name(), (Object)propertyKey.id());
        OlapPropertyKeyRemoveJob job = new OlapPropertyKeyRemoveJob();
        return SchemaTransactionV2.asyncRun(this.graph(), propertyKey, job);
    }

    public void removeOlapPk(Id id) {
        this.graphParams().loadGraphStore().removeOlapTable(id);
    }

    @Override
    public Id clearOlapPk(PropertyKey propertyKey) {
        LOG.debug("SchemaTransaction clear olap property key {} with id '{}'", (Object)propertyKey.name(), (Object)propertyKey.id());
        OlapPropertyKeyClearJob job = new OlapPropertyKeyClearJob();
        return SchemaTransactionV2.asyncRun(this.graph(), propertyKey, job);
    }

    public void clearOlapPk(Id id) {
        this.graphParams().loadGraphStore().clearOlapTable(id);
    }

    public Id createOlapPk(PropertyKey propertyKey) {
        LOG.debug("SchemaTransaction create olap property key {} with id '{}'", (Object)propertyKey.name(), (Object)propertyKey.id());
        OlapPropertyKeyCreateJob job = new OlapPropertyKeyCreateJob();
        return SchemaTransactionV2.asyncRun(this.graph(), propertyKey, job);
    }

    public void createOlapPk(Id id) {
        this.graphParams().loadGraphStore().createOlapTable(id);
    }

    public boolean existOlapTable(Id id) {
        return this.graphParams().loadGraphStore().existOlapTable(id);
    }

    public void initAndRegisterOlapTables() {
        for (PropertyKey pk : this.getPropertyKeys()) {
            if (!pk.olap()) continue;
            this.graphParams().loadGraphStore().checkAndRegisterOlapTable(pk.id());
        }
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id getNextId(HugeType type) {
        LOG.debug("SchemaTransaction get next id for {}", (Object)type);
        return this.idCounter.nextId(type);
    }

    @PerfUtil.Watched(prefix="schema")
    public void setNextIdLowest(HugeType type, long lowest) {
        LOG.debug("SchemaTransaction set next id to {} for {}", (Object)lowest, (Object)type);
        this.idCounter.setCounterLowest(type, lowest);
    }

    @PerfUtil.Watched(prefix="schema")
    public Id getNextSystemId() {
        LOG.debug("SchemaTransaction get next system id");
        Id id = this.idCounter.nextId(HugeType.SYS_SCHEMA);
        return IdGenerator.of(-id.asLong());
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id validOrGenerateId(HugeType type, Id id, String name) {
        boolean forSystem = Graph.Hidden.isHidden((String)name);
        if (id != null) {
            this.checkIdAndUpdateNextId(type, id, name, forSystem);
        } else {
            id = forSystem ? this.getNextSystemId() : this.getNextId(type);
        }
        return id;
    }

    private void checkIdAndUpdateNextId(HugeType type, Id id, String name, boolean forSystem) {
        if (forSystem) {
            if (id.number() && id.asLong() < 0L) {
                return;
            }
            throw new IllegalStateException(String.format("Invalid system id '%s'", id));
        }
        E.checkState((id.number() && id.asLong() > 0L ? 1 : 0) != 0, (String)"Schema id must be number and >0, but got '%s'", (Object[])new Object[]{id});
        GraphMode mode = this.graphMode();
        E.checkState((mode == GraphMode.RESTORING ? 1 : 0) != 0, (String)"Can't build schema with provided id '%s' when graph '%s' in mode '%s'", (Object[])new Object[]{id, this.graph, mode});
        this.setNextIdLowest(type, id.asLong());
    }

    @Override
    public void checkSchemaName(String name) {
        char[] filters;
        String illegalReg = (String)this.graphParams().configuration().get(CoreOptions.SCHEMA_ILLEGAL_NAME_REGEX);
        E.checkNotNull((Object)name, (String)"name");
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"The name can't be empty.", (Object[])new Object[0]);
        E.checkArgument((name.length() < 256 ? 1 : 0) != 0, (String)"The length of name must less than 256 bytes.", (Object[])new Object[0]);
        E.checkArgument((!name.matches(illegalReg) ? 1 : 0) != 0, (String)"Illegal schema name '%s'", (Object[])new Object[]{name});
        for (char c : filters = new char[]{'#', '>', ':', '!'}) {
            E.checkArgument((name.indexOf(c) == -1 ? 1 : 0) != 0, (String)"The name can't contain character '%s'.", (Object[])new Object[]{Character.valueOf(c)});
        }
    }

    @Override
    public String graphName() {
        return this.graph;
    }

    protected HugeGraphParams graphParams() {
        return this.graphParams;
    }

    @Override
    public GraphMode graphMode() {
        return this.graphParams().mode();
    }

    public HugeGraph graph() {
        return this.graphParams.graph();
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id rebuildIndex(SchemaElement schema) {
        return this.rebuildIndex(schema, (Set<Id>)ImmutableSet.of());
    }

    @Override
    @PerfUtil.Watched(prefix="schema")
    public Id rebuildIndex(SchemaElement schema, Set<Id> dependencies) {
        LOG.debug("SchemaTransaction rebuild index for {} with id '{}'", (Object)schema.type(), (Object)schema.id());
        IndexLabelRebuildJob job = new IndexLabelRebuildJob();
        return SchemaTransactionV2.asyncRun(this.graph(), schema, job, dependencies);
    }

    public void clear() {
        this.schemaMetaManager.clearAllSchema(this.graphSpace, this.graph);
    }
}

