/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft.rpc;

import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequestProcessor;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ListPeersProcessor
extends RpcRequestProcessor<RaftRequests.ListPeersRequest> {
    private static final Logger LOG = Log.logger(ListPeersProcessor.class);
    private final RaftContext context;

    public ListPeersProcessor(RaftContext context) {
        super(null, null);
        this.context = context;
    }

    public Message processRequest(RaftRequests.ListPeersRequest request, RpcRequestClosure done) {
        LOG.debug("Processing ListPeersRequest {}", request.getClass());
        RaftGroupManager nodeManager = this.context.raftNodeManager();
        try {
            RaftRequests.CommonResponse common = RaftRequests.CommonResponse.newBuilder().setStatus(true).build();
            return RaftRequests.ListPeersResponse.newBuilder().setCommon(common).addAllEndpoints(nodeManager.listPeers()).build();
        }
        catch (Throwable e) {
            RaftRequests.CommonResponse common = RaftRequests.CommonResponse.newBuilder().setStatus(false).setMessage(e.toString()).build();
            return RaftRequests.ListPeersResponse.newBuilder().setCommon(common).addAllEndpoints((Iterable<String>)ImmutableList.of()).build();
        }
    }

    public String interest() {
        return RaftRequests.ListPeersRequest.class.getName();
    }
}

