/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft.rpc;

import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequestProcessor;
import com.google.protobuf.Message;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class AddPeerProcessor
extends RpcRequestProcessor<RaftRequests.AddPeerRequest> {
    private static final Logger LOG = Log.logger(AddPeerProcessor.class);
    private final RaftContext context;

    public AddPeerProcessor(RaftContext context) {
        super(null, null);
        this.context = context;
    }

    public Message processRequest(RaftRequests.AddPeerRequest request, RpcRequestClosure done) {
        LOG.debug("Processing AddPeerRequest {}", request.getClass());
        RaftGroupManager nodeManager = this.context.raftNodeManager();
        try {
            nodeManager.addPeer(request.getEndpoint());
            RaftRequests.CommonResponse common = RaftRequests.CommonResponse.newBuilder().setStatus(true).build();
            return RaftRequests.AddPeerResponse.newBuilder().setCommon(common).build();
        }
        catch (Throwable e) {
            RaftRequests.CommonResponse common = RaftRequests.CommonResponse.newBuilder().setStatus(false).setMessage(e.toString()).build();
            return RaftRequests.AddPeerResponse.newBuilder().setCommon(common).build();
        }
    }

    public String interest() {
        return RaftRequests.AddPeerRequest.class.getName();
    }
}

