/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.backend.store.AbstractBackendStoreProvider;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.memory.InMemoryDBStore;
import org.apache.hugegraph.config.HugeConfig;

public class InMemoryDBStoreProvider
extends AbstractBackendStoreProvider {
    public static final String TYPE = "memory";
    private static Map<String, InMemoryDBStoreProvider> providers = null;

    public static boolean matchType(String type) {
        return TYPE.equalsIgnoreCase(type);
    }

    public static synchronized InMemoryDBStoreProvider instance(String graph) {
        if (providers == null) {
            providers = new ConcurrentHashMap<String, InMemoryDBStoreProvider>();
        }
        if (!providers.containsKey(graph)) {
            InMemoryDBStoreProvider p = new InMemoryDBStoreProvider(graph);
            providers.putIfAbsent(graph, p);
        }
        return providers.get(graph);
    }

    private InMemoryDBStoreProvider(String graph) {
        this.open(graph);
    }

    @Override
    public void open(String graph) {
        super.open(graph);
        this.notifyAndWaitEvent("store.init");
    }

    @Override
    protected BackendStore newSchemaStore(HugeConfig config, String store) {
        return new InMemoryDBStore.InMemorySchemaStore(this, this.graph(), store);
    }

    @Override
    protected BackendStore newGraphStore(HugeConfig config, String store) {
        return new InMemoryDBStore.InMemoryGraphStore(this, this.graph(), store);
    }

    @Override
    protected BackendStore newSystemStore(HugeConfig config, String store) {
        return new InMemoryDBStore.InMemorySystemStore(this, this.graph(), store);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public String driverVersion() {
        return "1.8";
    }
}

