/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.HugeResource;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class HugeTarget
extends SchemaDefine.Entity {
    private static final long serialVersionUID = -3361487778656878418L;
    private String name;
    private String graph;
    private String description;
    private String url;
    private List<HugeResource> resources;
    private static final List<HugeResource> EMPTY = ImmutableList.of();

    public HugeTarget(Id id) {
        this(id, null, null, null, EMPTY);
    }

    public HugeTarget(String name, String url) {
        this(null, name, name, url, EMPTY);
    }

    public HugeTarget(String name, String graph, String url) {
        this(null, name, graph, url, EMPTY);
    }

    public HugeTarget(String name, String graph, String url, List<HugeResource> resources) {
        this(null, name, graph, url, resources);
    }

    private HugeTarget(Id id, String name, String graph, String url, List<HugeResource> resources) {
        this.id = id;
        this.name = name;
        this.graph = graph;
        this.url = url;
        this.resources = resources;
    }

    @Override
    public ResourceType type() {
        return ResourceType.TARGET;
    }

    @Override
    public String label() {
        return P.TARGET;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String graph() {
        return this.graph;
    }

    public void graph(String graph) {
        this.graph = graph;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String url() {
        return this.url;
    }

    public void url(String url) {
        this.url = url;
    }

    public List<HugeResource> resources() {
        return this.resources;
    }

    public void resources(String resources) {
        try {
            this.resources = HugeResource.parseResources(resources);
        }
        catch (Exception e) {
            throw new HugeException("Invalid format of resources: %s", (Throwable)e, resources);
        }
    }

    public void resources(List<HugeResource> resources) {
        E.checkNotNull(resources, (String)"resources");
        this.resources = resources;
    }

    public String toString() {
        return String.format("HugeTarget(%s)%s", this.id, this.asMap());
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~target_name": {
                this.name = (String)value;
                break;
            }
            case "~target_graph": {
                this.graph = (String)value;
                break;
            }
            case "~target_url": {
                this.url = (String)value;
                break;
            }
            case "~target_resources": {
                this.resources = HugeResource.parseResources((String)value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Target name can't be null", (Object[])new Object[0]);
        E.checkState((this.url != null ? 1 : 0) != 0, (String)"Target url can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(16);
        list.add(T.label);
        list.add(P.TARGET);
        list.add("~target_name");
        list.add(this.name);
        list.add("~target_graph");
        list.add(this.graph);
        list.add("~target_url");
        list.add(this.url);
        if (this.resources != null && this.resources != EMPTY) {
            list.add("~target_resources");
            list.add(JsonUtil.toJson(this.resources));
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Target name can't be null", (Object[])new Object[0]);
        E.checkState((this.url != null ? 1 : 0) != 0, (String)"Target url can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)"~target_name"), this.name);
        map.put(Graph.Hidden.unHide((String)"~target_graph"), this.graph);
        map.put(Graph.Hidden.unHide((String)"~target_url"), this.url);
        if (this.resources != null && this.resources != EMPTY) {
            map.put(Graph.Hidden.unHide((String)"~target_resources"), this.resources);
        }
        return super.asMap(map);
    }

    public static HugeTarget fromVertex(Vertex vertex) {
        HugeTarget target = new HugeTarget((Id)vertex.id());
        return HugeTarget.fromVertex(vertex, target);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static HugeTarget fromMap(Map<String, Object> map) {
        HugeTarget target = new HugeTarget(null);
        return HugeTarget.fromMap(map, target);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.TARGET);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existVertexLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            VertexLabel label = (VertexLabel)this.schema().vertexLabel(this.label).properties(properties).usePrimaryKeyId().primaryKeys("~target_name").nullableKeys("~target_resources").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addVertexLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~target_name"));
            props.add(this.createPropertyKey("~target_graph"));
            props.add(this.createPropertyKey("~target_url"));
            props.add(this.createPropertyKey("~target_resources"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String TARGET = Graph.Hidden.hide((String)"target");
        public static final String ID = T.id.getAccessor();
        public static final String LABEL = T.label.getAccessor();
        public static final String NAME = "~target_name";
        public static final String GRAPH = "~target_graph";
        public static final String URL = "~target_url";
        public static final String RESS = "~target_resources";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"target_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

