/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.dic.DictionaryFactory;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class JcsegAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"Simple", (Object)"Complex");
    private static final SegmenterConfig CONFIG = new SegmenterConfig();
    private static final ADictionary DIC = DictionaryFactory.createDefaultDictionary((SegmenterConfig)CONFIG);
    private final ISegment.Type type;

    public JcsegAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for jcseg analyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.type = "Simple".equals(mode) ? ISegment.SIMPLE : ISegment.COMPLEX;
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        try {
            IWord word;
            ISegment segmentor = this.type.factory.create(CONFIG, DIC);
            segmentor.reset((Reader)new StringReader(text));
            while ((word = segmentor.next()) != null) {
                result.add(word.getValue());
            }
        }
        catch (Exception e) {
            throw new HugeException("Jcseg segment text '%s' failed", (Throwable)e, text);
        }
        return result;
    }
}

