/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class ExceptionUtil {
    public static Throwable rootCause(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static RuntimeException transToRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(ExceptionUtil.rootCause(e).getMessage(), e);
    }

    public static <T> T futureGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.transToRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw ExceptionUtil.transToRuntimeException(e.getCause());
        }
    }
}

