/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.iterator;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.hugegraph.iterator.WrappedIterator;
import org.apache.hugegraph.util.E;

public class ExtendableIterator<T>
extends WrappedIterator<T> {
    private final Deque<Iterator<T>> itors = new ConcurrentLinkedDeque<Iterator<T>>();
    private Iterator<T> currentIterator = null;

    public ExtendableIterator() {
    }

    public ExtendableIterator(Iterator<T> iter) {
        this();
        this.extend(iter);
    }

    public ExtendableIterator(Iterator<T> itor1, Iterator<T> itor2) {
        this();
        this.extend(itor1);
        this.extend(itor2);
    }

    public ExtendableIterator<T> extend(Iterator<T> iter) {
        E.checkState(this.currentIterator == null, "Can't extend iterator after iterating", new Object[0]);
        if (iter != null) {
            this.itors.addLast(iter);
        }
        return this;
    }

    public static <T> ExtendableIterator<T> concat(Iterator<T> lhs, Iterator<T> rhs) {
        Preconditions.checkNotNull(lhs);
        Preconditions.checkNotNull(rhs);
        if (lhs instanceof ExtendableIterator) {
            return ((ExtendableIterator)lhs).extend(rhs);
        }
        return new ExtendableIterator<T>(lhs, rhs);
    }

    @Override
    public void close() throws Exception {
        for (Iterator<T> iter : this.itors) {
            if (!(iter instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)iter)).close();
        }
    }

    @Override
    protected Iterator<T> originIterator() {
        return this.currentIterator;
    }

    @Override
    protected boolean fetch() {
        Iterator<T> first;
        assert (this.current == ExtendableIterator.none());
        if (this.itors.isEmpty()) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.current = this.currentIterator.next();
            return true;
        }
        while ((first = this.itors.peekFirst()) != null && !first.hasNext()) {
            if (first == this.itors.peekLast() && this.itors.size() == 1) {
                this.currentIterator = first;
                return false;
            }
            ExtendableIterator.close(this.itors.removeFirst());
        }
        assert (first != null && first.hasNext());
        this.currentIterator = first;
        this.current = this.currentIterator.next();
        return true;
    }
}

