/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import java.util.List;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.store.mysql.MysqlUtil;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.util.E;

public class WhereBuilder {
    private StringBuilder builder;

    public WhereBuilder() {
        this(true);
    }

    public WhereBuilder(boolean startWithWhere) {
        this.builder = startWithWhere ? new StringBuilder(" WHERE ") : new StringBuilder(" ");
    }

    public WhereBuilder relation(String key, Condition.RelationType type, Object value) {
        String operator = null;
        switch (type) {
            case EQ: {
                operator = "=";
                break;
            }
            case NEQ: {
                operator = "!=";
                break;
            }
            case GT: {
                operator = ">";
                break;
            }
            case GTE: {
                operator = ">=";
                break;
            }
            case LT: {
                operator = "<";
                break;
            }
            case LTE: {
                operator = "<=";
                break;
            }
            case IN: {
                List values = (List)value;
                this.in(key, values);
                break;
            }
            default: {
                throw new NotSupportException("relation '%s'", new Object[]{type});
            }
        }
        if (operator != null) {
            this.builder.append(key);
            this.builder.append(operator);
            this.builder.append(this.wrapStringIfNeeded(value));
        }
        return this;
    }

    public WhereBuilder and() {
        this.builder.append(" AND ");
        return this;
    }

    public WhereBuilder and(List<String> keys, String operator) {
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            this.builder.append(keys.get(i));
            this.builder.append(operator);
            this.builder.append("?");
            if (i == n - 1) continue;
            this.builder.append(" AND ");
        }
        return this;
    }

    public WhereBuilder and(List<String> keys, List<Object> values) {
        return this.and(keys, "=", values);
    }

    public WhereBuilder and(List<String> keys, String operator, List<Object> values) {
        E.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (String)"The size of keys '%s' is not equal with values size '%s'", (Object[])new Object[]{keys.size(), values.size()});
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            this.builder.append(keys.get(i));
            this.builder.append(operator);
            this.builder.append(this.wrapStringIfNeeded(values.get(i)));
            if (i == n - 1) continue;
            this.builder.append(" AND ");
        }
        return this;
    }

    public WhereBuilder and(List<String> keys, List<String> operators, List<Object> values) {
        E.checkArgument((keys.size() == operators.size() ? 1 : 0) != 0, (String)"The size of keys '%s' is not equal with operators size '%s'", (Object[])new Object[]{keys.size(), operators.size()});
        E.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (String)"The size of keys '%s' is not equal with values size '%s'", (Object[])new Object[]{keys.size(), values.size()});
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            this.builder.append(keys.get(i));
            this.builder.append(operators.get(i));
            this.builder.append(this.wrapStringIfNeeded(values.get(i)));
            if (i == n - 1) continue;
            this.builder.append(" AND ");
        }
        return this;
    }

    public WhereBuilder and(List<StringBuilder> clauses) {
        E.checkArgument((clauses != null && !clauses.isEmpty() ? 1 : 0) != 0, (String)"The clauses can't be empty", (Object[])new Object[0]);
        int size = clauses.size();
        int i = 0;
        for (StringBuilder clause : clauses) {
            this.builder.append((CharSequence)clause);
            if (++i == size) continue;
            this.builder.append(" AND ");
        }
        return this;
    }

    public WhereBuilder in(String key, List<Object> values) {
        this.builder.append(key).append(" IN (");
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            this.builder.append(this.wrapStringIfNeeded(values.get(i)));
            if (i == n - 1) continue;
            this.builder.append(", ");
        }
        this.builder.append(")");
        return this;
    }

    public WhereBuilder gte(List<String> keys, List<Object> values) {
        int i;
        E.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (String)"The size of keys '%s' is not equal with values size '%s'", (Object[])new Object[]{keys.size(), values.size()});
        this.builder.append("(");
        int n = keys.size();
        for (i = 0; i < n; ++i) {
            this.builder.append(keys.get(i));
            if (i == n - 1) continue;
            this.builder.append(", ");
        }
        this.builder.append(") >= (");
        n = values.size();
        for (i = 0; i < n; ++i) {
            this.builder.append(this.wrapStringIfNeeded(values.get(i)));
            if (i == n - 1) continue;
            this.builder.append(", ");
        }
        this.builder.append(")");
        return this;
    }

    public WhereBuilder gte(String key, Object value) {
        this.builder.append(" ").append(key).append(" >= ").append(this.wrapStringIfNeeded(value)).append(" ");
        return this;
    }

    public WhereBuilder lt(String key, Object value) {
        this.builder.append(" ").append(key).append(" < ").append(this.wrapStringIfNeeded(value)).append(" ");
        return this;
    }

    public StringBuilder build() {
        return this.builder;
    }

    public String toString() {
        return this.builder.toString();
    }

    protected String wrapStringIfNeeded(Object value) {
        if (value instanceof String) {
            return this.escapeAndWrapString((String)value);
        }
        return String.valueOf(value);
    }

    protected String escapeAndWrapString(String value) {
        return MysqlUtil.escapeAndWrapString(value);
    }
}

