/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.traversal;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ParameterNormalizer {
    private ParameterNormalizer() {
    }

    public static Map<String, Object> normalize(Map<String, ?> parameters) {
        return ParameterNormalizer.normalizeMap(parameters);
    }

    private static Object normalizeValue(Object value) {
        if (value instanceof Map) {
            return ParameterNormalizer.normalizeMap((Map)value);
        }
        if (value instanceof List) {
            return ParameterNormalizer.normalizeList((List)value);
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value == null) {
            return "  cypher.null";
        }
        return value;
    }

    private static Map<String, Object> normalizeMap(Map<?, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            String key = String.valueOf(e.getKey());
            Object value = ParameterNormalizer.normalizeValue(e.getValue());
            result.put(key, value);
        }
        return result;
    }

    private static List<Object> normalizeList(List<?> list) {
        return list.stream().map(ParameterNormalizer::normalizeValue).collect(Collectors.toList());
    }
}

