/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hugegraph.pd.client.Discoverable;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.discovery.DiscoveryServiceGrpc;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.grpc.discovery.RegisterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryClient
implements Closeable,
Discoverable {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClient.class);
    private final Timer timer = new Timer("serverHeartbeat", true);
    private final AtomicBoolean requireResetStub = new AtomicBoolean(false);
    protected int period;
    LinkedList<String> pdAddresses = new LinkedList();
    ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private volatile int currentIndex;
    private int maxTime = 6;
    private ManagedChannel channel = null;
    private DiscoveryServiceGrpc.DiscoveryServiceBlockingStub registerStub;
    private DiscoveryServiceGrpc.DiscoveryServiceBlockingStub blockingStub;

    public DiscoveryClient(String centerAddress, int delay) {
        String[] addresses = centerAddress.split(",");
        for (int i = 0; i < addresses.length; ++i) {
            String singleAddress = addresses[i];
            if (singleAddress == null || singleAddress.length() <= 0) continue;
            this.pdAddresses.add(addresses[i]);
        }
        this.period = delay;
        if (this.maxTime < addresses.length) {
            this.maxTime = addresses.length;
        }
    }

    private <V, R> R tryWithTimes(Function<V, R> function, V v) {
        Throwable ex = null;
        for (int i = 0; i < this.maxTime; ++i) {
            try {
                R r = function.apply(v);
                return r;
            }
            catch (Exception e) {
                this.requireResetStub.set(true);
                this.resetStub();
                ex = e;
                continue;
            }
        }
        if (ex != null) {
            log.error("Try discovery method with error: {}", (Object)ex.getMessage());
        }
        return null;
    }

    private void resetStub() {
        String errLog = null;
        for (int i = this.currentIndex + 1; i <= this.pdAddresses.size() + this.currentIndex; ++i) {
            this.currentIndex = i % this.pdAddresses.size();
            String singleAddress = this.pdAddresses.get(this.currentIndex);
            try {
                if (this.requireResetStub.get()) {
                    this.resetChannel(singleAddress);
                }
                errLog = null;
                break;
            }
            catch (Exception e) {
                this.requireResetStub.set(true);
                if (errLog != null) continue;
                errLog = e.getMessage();
                continue;
            }
        }
        if (errLog != null) {
            log.error(errLog);
        }
    }

    private void resetChannel(String singleAddress) throws PDException {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.requireResetStub.get()) {
                while (this.channel != null && !this.channel.shutdownNow().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                }
                this.channel = ManagedChannelBuilder.forTarget((String)singleAddress).usePlaintext().build();
                this.registerStub = DiscoveryServiceGrpc.newBlockingStub((Channel)this.channel);
                this.blockingStub = DiscoveryServiceGrpc.newBlockingStub((Channel)this.channel);
                this.requireResetStub.set(false);
            }
        }
        catch (Exception e) {
            throw new PDException(-1, String.format("Reset channel with error : %s.", e.getMessage()));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public NodeInfos getNodeInfos(Query query) {
        return this.tryWithTimes(q -> {
            NodeInfos nodes;
            this.readWriteLock.readLock().lock();
            try {
                nodes = this.blockingStub.getNodes(q);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            return nodes;
        }, query);
    }

    @Override
    public void scheduleTask() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                NodeInfo nodeInfo = DiscoveryClient.this.getRegisterNode();
                DiscoveryClient.this.tryWithTimes(t -> {
                    RegisterInfo register;
                    DiscoveryClient.this.readWriteLock.readLock().lock();
                    try {
                        register = DiscoveryClient.this.registerStub.register(t);
                        log.debug("Discovery Client work done.");
                        Consumer<RegisterInfo> consumer = DiscoveryClient.this.getRegisterConsumer();
                        if (consumer != null) {
                            consumer.accept(register);
                        }
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        DiscoveryClient.this.readWriteLock.readLock().unlock();
                    }
                    return register;
                }, nodeInfo);
            }
        }, 0L, (long)this.period);
    }

    abstract NodeInfo getRegisterNode();

    abstract Consumer<RegisterInfo> getRegisterConsumer();

    @Override
    public void cancelTask() {
        this.timer.cancel();
    }

    @Override
    public void close() {
        this.timer.cancel();
        this.readWriteLock.writeLock().lock();
        try {
            while (this.channel != null && !this.channel.shutdownNow().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (Exception e) {
            log.info("Close channel with error : {}.", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

