/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/vertices")
@Singleton
@Tag(name="VerticesAPI")
public class VerticesAPI
extends API {
    private static final Logger LOG = Log.logger(VerticesAPI.class);

    @GET
    @Timed
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="ids") List<String> stringIds) {
        LOG.debug("Graph [{}] get vertices by ids: {}", (Object)graph, stringIds);
        E.checkArgument((stringIds != null && !stringIds.isEmpty() ? 1 : 0) != 0, (String)"The ids parameter can't be null or empty", (Object[])new Object[0]);
        Object[] ids = new Id[stringIds.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = VertexAPI.checkAndParseVertexId(stringIds.get(i));
        }
        HugeGraph g = VerticesAPI.graph(manager, graph);
        Iterator vertices = g.vertices(ids);
        return manager.serializer((Graph)g).writeVertices(vertices, false);
    }

    @GET
    @Timed
    @Path(value="shards")
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    public String shards(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="split_size") long splitSize) {
        LOG.debug("Graph [{}] get vertex shards with split size '{}'", (Object)graph, (Object)splitSize);
        HugeGraph g = VerticesAPI.graph(manager, graph);
        List shards = (List)g.metadata(HugeType.VERTEX, "splits", new Object[]{splitSize});
        return manager.serializer((Graph)g).writeList("shards", shards);
    }

    @GET
    @Timed
    @Path(value="scan")
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    public String scan(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="page") String page, @QueryParam(value="page_limit") @DefaultValue(value="100000") long pageLimit) {
        LOG.debug("Graph [{}] query vertices by shard(start: {}, end: {}, page: {}) ", new Object[]{graph, start, end, page});
        HugeGraph g = VerticesAPI.graph(manager, graph);
        ConditionQuery query = new ConditionQuery(HugeType.VERTEX);
        query.scan(start, end);
        query.page(page);
        if (query.paging()) {
            query.limit(pageLimit);
        }
        Iterator vertices = g.vertices((Query)query);
        return manager.serializer((Graph)g).writeVertices(vertices, query.paging());
    }
}

