/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.job;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.RedirectFilter;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.job.AlgorithmJob;
import org.apache.hugegraph.job.Job;
import org.apache.hugegraph.job.JobBuilder;
import org.apache.hugegraph.server.RestServer;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/jobs/algorithm")
@Singleton
@Tag(name="AlgorithmAPI")
public class AlgorithmAPI
extends API {
    private static final Logger LOG = Log.logger(RestServer.class);

    @POST
    @Timed
    @Path(value="/{name}")
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Id> post(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String algorithm, Map<String, Object> parameters) {
        LOG.debug("Graph [{}] schedule algorithm job: {}", (Object)graph, parameters);
        E.checkArgument((algorithm != null && !algorithm.isEmpty() ? 1 : 0) != 0, (String)"The algorithm name can't be empty", (Object[])new Object[0]);
        if (parameters == null) {
            parameters = ImmutableMap.of();
        }
        if (!AlgorithmJob.check((String)algorithm, (Map)parameters)) {
            throw new NotFoundException("Not found algorithm: " + algorithm);
        }
        HugeGraph g = AlgorithmAPI.graph(manager, graph);
        ImmutableMap input = ImmutableMap.of((Object)"algorithm", (Object)algorithm, (Object)"parameters", (Object)parameters);
        JobBuilder builder = JobBuilder.of((HugeGraph)g);
        builder.name("algorithm:" + algorithm).input(JsonUtil.toJson((Object)input)).job((Job)new AlgorithmJob());
        return ImmutableMap.of((Object)"task_id", (Object)builder.schedule().id());
    }
}

