/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.gremlin;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.api.gremlin.GremlinQueryAPI;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.util.E;

@Path(value="gremlin")
@Singleton
@Tag(name="GremlinAPI")
public class GremlinAPI
extends GremlinQueryAPI {
    private static final Histogram GREMLIN_INPUT_HISTOGRAM = MetricsUtil.registerHistogram(GremlinAPI.class, "gremlin-input");
    private static final Histogram GREMLIN_OUTPUT_HISTOGRAM = MetricsUtil.registerHistogram(GremlinAPI.class, "gremlin-output");

    @POST
    @Timed
    @CompressInterceptor.Compress
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response post(@Context HugeConfig conf, @Context HttpHeaders headers, String request) {
        String auth = headers.getHeaderString("Authorization");
        Response response = this.client().doPostRequest(auth, request);
        GREMLIN_INPUT_HISTOGRAM.update(request.length());
        GREMLIN_OUTPUT_HISTOGRAM.update(response.getLength());
        return GremlinAPI.transformResponseIfNeeded(response);
    }

    @GET
    @Timed
    @CompressInterceptor.Compress(buffer=40960)
    @Produces(value={"application/json;charset=UTF-8"})
    public Response get(@Context HugeConfig conf, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        String auth = headers.getHeaderString("Authorization");
        String query = uriInfo.getRequestUri().getRawQuery();
        E.checkArgumentNotNull((Object)query, (String)"The request query can't be empty", (Object[])new Object[0]);
        MultivaluedMap params = uriInfo.getQueryParameters();
        Response response = this.client().doGetRequest(auth, (MultivaluedMap<String, String>)params);
        GREMLIN_INPUT_HISTOGRAM.update(query.length());
        GREMLIN_OUTPUT_HISTOGRAM.update(response.getLength());
        return GremlinAPI.transformResponseIfNeeded(response);
    }
}

