/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hbase;

import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class HbaseOptions
extends OptionHolder {
    private static volatile HbaseOptions instance;
    public static final ConfigOption<String> HBASE_HOSTS;
    public static final ConfigOption<Integer> HBASE_PORT;
    public static final ConfigOption<String> HBASE_ZNODE_PARENT;
    public static final ConfigOption<Integer> HBASE_ZK_RETRY;
    public static final ConfigOption<Integer> HBASE_THREADS_MAX;
    public static final ConfigOption<Long> TRUNCATE_TIMEOUT;
    public static final ConfigOption<Long> AGGR_TIMEOUT;
    public static final ConfigOption<Boolean> HBASE_KERBEROS_ENABLE;
    public static final ConfigOption<String> HBASE_KRB5_CONF;
    public static final ConfigOption<String> HBASE_HBASE_SITE;
    public static final ConfigOption<String> HBASE_KERBEROS_PRINCIPAL;
    public static final ConfigOption<String> HBASE_KERBEROS_KEYTAB;
    public static final ConfigOption<Boolean> HBASE_ENABLE_PARTITION;
    public static final ConfigOption<Integer> HBASE_VERTEX_PARTITION;
    public static final ConfigOption<Integer> HBASE_EDGE_PARTITION;

    private HbaseOptions() {
    }

    public static synchronized HbaseOptions instance() {
        if (instance == null) {
            instance = new HbaseOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        HBASE_HOSTS = new ConfigOption("hbase.hosts", "The hostnames or ip addresses of HBase zookeeper, separated with commas.", OptionChecker.disallowEmpty(), (Object)"localhost");
        HBASE_PORT = new ConfigOption("hbase.port", "The port address of HBase zookeeper.", OptionChecker.rangeInt((Number)1, (Number)65535), (Object)2181);
        HBASE_ZNODE_PARENT = new ConfigOption("hbase.znode_parent", "The znode parent path of HBase zookeeper.", OptionChecker.disallowEmpty(), (Object)"/hbase");
        HBASE_ZK_RETRY = new ConfigOption("hbase.zk_retry", "The recovery retry times of HBase zookeeper.", OptionChecker.rangeInt((Number)0, (Number)1000), (Object)3);
        HBASE_THREADS_MAX = new ConfigOption("hbase.threads_max", "The max threads num of hbase connections.", OptionChecker.rangeInt((Number)1, (Number)1000), (Object)64);
        TRUNCATE_TIMEOUT = new ConfigOption("hbase.truncate_timeout", "The timeout in seconds of waiting for store truncate.", OptionChecker.positiveInt(), (Object)30L);
        AGGR_TIMEOUT = new ConfigOption("hbase.aggregation_timeout", "The timeout in seconds of waiting for aggregation.", OptionChecker.positiveInt(), (Object)43200L);
        HBASE_KERBEROS_ENABLE = new ConfigOption("hbase.kerberos_enable", "Is Kerberos authentication enabled for HBase.", OptionChecker.disallowEmpty(), (Object)false);
        HBASE_KRB5_CONF = new ConfigOption("hbase.krb5_conf", "Kerberos configuration file, including KDC IP, default realm, etc.", null, (Object)"/etc/krb5.conf");
        HBASE_HBASE_SITE = new ConfigOption("hbase.hbase_site", "The HBase's configuration file", null, (Object)"/etc/hbase/conf/hbase-site.xml");
        HBASE_KERBEROS_PRINCIPAL = new ConfigOption("hbase.kerberos_principal", "The HBase's principal for kerberos authentication.", null, (Object)"");
        HBASE_KERBEROS_KEYTAB = new ConfigOption("hbase.kerberos_keytab", "The HBase's key tab file for kerberos authentication.", null, (Object)"");
        HBASE_ENABLE_PARTITION = new ConfigOption("hbase.enable_partition", "Is pre-split partitions enabled for HBase.", OptionChecker.disallowEmpty(), (Object)true);
        HBASE_VERTEX_PARTITION = new ConfigOption("hbase.vertex_partitions", "The number of partitions of the HBase vertex table", OptionChecker.nonNegativeInt(), (Object)10);
        HBASE_EDGE_PARTITION = new ConfigOption("hbase.edge_partitions", "The number of partitions of the HBase edge table", OptionChecker.nonNegativeInt(), (Object)30);
    }
}

