/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.controller;

import java.util.ArrayList;
import org.apache.hugegraph.store.PartitionEngine;
import org.apache.hugegraph.store.meta.Partition;
import org.apache.hugegraph.store.meta.Store;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class HgTestController {
    private static final Logger log = LoggerFactory.getLogger(HgTestController.class);
    @Autowired
    HgStoreNodeService nodeService;

    @GetMapping(value={"/leaderStore"}, produces={"application/json"})
    public Store testGetStoreInfo() {
        Store store = null;
        PartitionEngine engine = this.nodeService.getStoreEngine().getPartitionEngine(Integer.valueOf(0));
        for (Partition partition : engine.getPartitions().values()) {
            store = this.nodeService.getStoreEngine().getHgCmdClient().getStoreInfo(engine.getLeader().toString());
        }
        return store;
    }

    @GetMapping(value={"/raftRestart/{groupId}"}, produces={"application/json"})
    public String restartRaftNode(@PathVariable(value="groupId") int groupId) {
        PartitionEngine engine = this.nodeService.getStoreEngine().getPartitionEngine(Integer.valueOf(groupId));
        engine.restartRaftNode();
        return "OK";
    }

    @GetMapping(value={"/raftDelete/{groupId}"}, produces={"application/json"})
    public String deleteRaftNode(@PathVariable(value="groupId") int groupId) {
        ArrayList graphs = new ArrayList();
        PartitionEngine engine = this.nodeService.getStoreEngine().getPartitionEngine(Integer.valueOf(groupId));
        if (engine != null) {
            engine.getPartitions().forEach((k, v) -> graphs.add(v.getGraphName()));
            this.nodeService.getStoreEngine().destroyPartitionEngine(Integer.valueOf(groupId), graphs);
            return "OK";
        }
        return "Partition not found";
    }

    @GetMapping(value={"/gc"}, produces={"application/json"})
    public String doGc() {
        System.gc();
        return "gc OK!";
    }

    @GetMapping(value={"/flush"}, produces={"application/json"})
    public String doFlush() {
        this.nodeService.getStoreEngine().getBusinessHandler().flushAll();
        return "flush all!";
    }

    @GetMapping(value={"/close"}, produces={"application/json"})
    public String doCloseAll() {
        this.nodeService.getStoreEngine().getBusinessHandler().closeAll();
        return "close all!";
    }

    @GetMapping(value={"/snapshot"}, produces={"application/json"})
    public String doSnapshot() {
        this.nodeService.getStoreEngine().getPartitionEngines().forEach((k, v) -> v.snapshot());
        return "snapshot OK!";
    }

    @GetMapping(value={"/compact"}, produces={"application/json"})
    public String dbCompaction() {
        this.nodeService.getStoreEngine().getPartitionEngines().forEach((k, v) -> this.nodeService.getStoreEngine().getBusinessHandler().dbCompaction("", k.intValue()));
        return "snapshot OK!";
    }
}

