/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.controller;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.Serializable;
import org.apache.hugegraph.store.grpc.state.ScanState;
import org.apache.hugegraph.store.node.entry.RestResult;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeState;
import org.apache.hugegraph.store.node.grpc.HgStoreStreamImpl;
import org.apache.hugegraph.store.node.model.HgNodeStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HgStoreStatusController {
    @Autowired
    HgStoreStreamImpl streamImpl;

    @GetMapping(value={"/-/echo"})
    public HgNodeStatus greeting(@RequestParam(value="name", defaultValue="World") String name) {
        return new HgNodeStatus(0, name + " is ok.");
    }

    @GetMapping(value={"/-/state"})
    public HgNodeStatus getState() {
        return new HgNodeStatus(0, HgStoreNodeState.getState().name());
    }

    @PutMapping(value={"/-/state"})
    public HgNodeStatus setState(@RequestParam(value="name") String name) {
        switch (name) {
            case "starting": {
                HgStoreNodeState.goStarting();
                break;
            }
            case "online": {
                HgStoreNodeState.goOnline();
                break;
            }
            case "stopping": {
                HgStoreNodeState.goStopping();
                break;
            }
            default: {
                return new HgNodeStatus(1000, "invalid parameter: " + name);
            }
        }
        return new HgNodeStatus(0, name);
    }

    @GetMapping(value={"/-/scan"}, produces={"application/json"})
    @ResponseBody
    public Serializable getScanState() {
        RestResult result = new RestResult();
        try {
            ScanState state = this.streamImpl.getState();
            JsonFormat.Printer printer = JsonFormat.printer();
            printer = printer.includingDefaultValueFields().preservingProtoFieldNames();
            return printer.print((MessageOrBuilder)state);
        }
        catch (Exception e) {
            result.setState("ERR");
            result.setMessage(e.getMessage());
            return result;
        }
    }
}

