/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.log;

import com.alipay.sofa.common.profile.StringUtil;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.impl.RocksDBLogStorage;
import com.alipay.sofa.jraft.storage.log.AbortFile;
import com.alipay.sofa.jraft.storage.log.CheckpointFile;
import com.alipay.sofa.jraft.storage.log.SegmentFile;
import com.alipay.sofa.jraft.util.ArrayDeque;
import com.alipay.sofa.jraft.util.Bits;
import com.alipay.sofa.jraft.util.CountDownEvent;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Platform;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBSegmentLogStorage
extends RocksDBLogStorage {
    private static final int PRE_ALLOCATE_SEGMENT_COUNT = 2;
    private static final int MEM_SEGMENT_COUNT = 3;
    private static final String SEGMENT_FILE_POSFIX = ".s";
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBSegmentLogStorage.class);
    private static final int DEFAULT_CHECKPOINT_INTERVAL_MS = SystemPropertyUtil.getInt("jraft.log_storage.segment.checkpoint.interval.ms", 5000);
    private static final int LOCATION_METADATA_SIZE = SegmentFile.RECORD_MAGIC_BYTES_SIZE + 2 + 8 + 4;
    private static final int MAX_SEGMENT_FILE_SIZE = SystemPropertyUtil.getInt("jraft.log_storage.segment.max.size.bytes", 0x40000000);
    private static int DEFAULT_VALUE_SIZE_THRESHOLD = SystemPropertyUtil.getInt("jraft.log_storage.segment.value.threshold.bytes", 4096);
    private final int valueSizeThreshold;
    private final String segmentsPath;
    private final CheckpointFile checkpointFile;
    private List<SegmentFile> segments;
    private ArrayDeque<AllocatedResult> blankSegments;
    private final Lock allocateLock = new ReentrantLock();
    private final Condition fullCond = this.allocateLock.newCondition();
    private final Condition emptyCond = this.allocateLock.newCondition();
    private final AtomicLong nextFileSequence = new AtomicLong(0L);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private ScheduledExecutorService checkpointExecutor;
    private final AbortFile abortFile;
    private final ThreadPoolExecutor writeExecutor;
    private Thread segmentAllocator;
    private final int maxSegmentFileSize;
    private int preAllocateSegmentCount = 2;
    private int keepInMemorySegmentCount = 3;
    private int checkpointIntervalMs = DEFAULT_CHECKPOINT_INTERVAL_MS;
    private static final Pattern SEGMENT_FILE_NAME_PATTERN = Pattern.compile("[0-9]+\\.s");

    public static final Builder builder(String uri, RaftOptions raftOptions) {
        return new Builder().setPath(uri).setRaftOptions(raftOptions);
    }

    public RocksDBSegmentLogStorage(String path, RaftOptions raftOptions) {
        this(path, raftOptions, DEFAULT_VALUE_SIZE_THRESHOLD, MAX_SEGMENT_FILE_SIZE);
    }

    public RocksDBSegmentLogStorage(String path, RaftOptions raftOptions, int valueSizeThreshold, int maxSegmentFileSize) {
        this(path, raftOptions, valueSizeThreshold, maxSegmentFileSize, 2, 3, DEFAULT_CHECKPOINT_INTERVAL_MS, RocksDBSegmentLogStorage.createDefaultWriteExecutor());
    }

    private static ThreadPoolExecutor createDefaultWriteExecutor() {
        return ThreadPoolUtil.newThreadPool("RocksDBSegmentLogStorage-write-pool", true, Utils.cpus(), Utils.cpus() * 3, 60L, new ArrayBlockingQueue<Runnable>(10000), new NamedThreadFactory("RocksDBSegmentLogStorageWriter"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public RocksDBSegmentLogStorage(String path, RaftOptions raftOptions, int valueSizeThreshold, int maxSegmentFileSize, int preAllocateSegmentCount, int keepInMemorySegmentCount, int checkpointIntervalMs, ThreadPoolExecutor writeExecutor) {
        super(path, raftOptions);
        if (Platform.isMac()) {
            LOG.warn("RocksDBSegmentLogStorage is not recommended on mac os x, it's performance is poorer than RocksDBLogStorage.");
        }
        Requires.requireTrue(maxSegmentFileSize > 0, "maxSegmentFileSize is not greater than zero");
        Requires.requireTrue(preAllocateSegmentCount > 0, "preAllocateSegmentCount is not greater than zero");
        Requires.requireTrue(checkpointIntervalMs > 0, "checkpointIntervalMs is not greater than zero");
        Requires.requireTrue(keepInMemorySegmentCount > 0, "keepInMemorySegmentCount is not greater than zero");
        this.segmentsPath = path + File.separator + "segments";
        this.abortFile = new AbortFile(this.segmentsPath + File.separator + "abort");
        this.checkpointFile = new CheckpointFile(this.segmentsPath + File.separator + "checkpoint");
        this.valueSizeThreshold = valueSizeThreshold;
        this.maxSegmentFileSize = maxSegmentFileSize;
        this.writeExecutor = writeExecutor == null ? RocksDBSegmentLogStorage.createDefaultWriteExecutor() : writeExecutor;
        this.preAllocateSegmentCount = preAllocateSegmentCount;
        this.checkpointIntervalMs = checkpointIntervalMs;
        this.keepInMemorySegmentCount = keepInMemorySegmentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile getLastSegmentFile(long logIndex, int waitToWroteSize, boolean createIfNecessary, RocksDBLogStorage.WriteContext ctx) throws IOException, InterruptedException {
        SegmentFile lastFile;
        block7: {
            int segmentCount;
            lastFile = null;
            do {
                segmentCount = 0;
                this.readLock.lock();
                try {
                    if (!this.segments.isEmpty()) {
                        segmentCount = this.segments.size();
                        SegmentFile currLastFile = this.getLastSegmentWithoutLock();
                        if (waitToWroteSize <= 0 || !currLastFile.reachesFileEndBy(waitToWroteSize)) {
                            lastFile = currLastFile;
                        }
                    }
                }
                finally {
                    this.readLock.unlock();
                }
                if (lastFile != null || !createIfNecessary) break block7;
            } while ((lastFile = this.createNewSegmentFile(logIndex, segmentCount, ctx)) == null);
            return lastFile;
        }
        return lastFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile createNewSegmentFile(long logIndex, int oldSegmentCount, RocksDBLogStorage.WriteContext ctx) throws InterruptedException, IOException {
        SegmentFile segmentFile = null;
        this.writeLock.lock();
        try {
            if (this.segments.size() != oldSegmentCount) {
                SegmentFile segmentFile2 = segmentFile;
                return segmentFile2;
            }
            if (!this.segments.isEmpty()) {
                SegmentFile currLastFile = this.getLastSegmentWithoutLock();
                currLastFile.setLastLogIndex(logIndex - 1L);
                ctx.startJob();
                ctx.addFinishHook(() -> currLastFile.setReadOnly(true));
                this.writeExecutor.execute(() -> {
                    try {
                        currLastFile.sync(this.isSync());
                    }
                    catch (IOException e) {
                        ctx.setError(e);
                    }
                    finally {
                        ctx.finishJob();
                    }
                });
            }
            SegmentFile segmentFile3 = segmentFile = this.allocateSegmentFile(logIndex);
            return segmentFile3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile allocateSegmentFile(long index) throws InterruptedException, IOException {
        this.allocateLock.lock();
        try {
            while (this.blankSegments.isEmpty()) {
                this.emptyCond.await();
            }
            AllocatedResult result = this.blankSegments.pollFirst();
            if (result.ie != null) {
                throw result.ie;
            }
            this.fullCond.signal();
            result.segmentFile.setFirstLogIndex(index);
            this.segments.add(result.segmentFile);
            SegmentFile segmentFile = result.segmentFile;
            return segmentFile;
        }
        finally {
            this.allocateLock.unlock();
        }
    }

    private SegmentFile allocateNewSegmentFile() throws IOException {
        String newSegPath = this.getNewSegmentFilePath();
        SegmentFile segmentFile = new SegmentFile(this.maxSegmentFileSize, newSegPath, this.writeExecutor);
        SegmentFile.SegmentFileOptions opts = SegmentFile.SegmentFileOptions.builder().setSync(false).setRecover(false).setLastFile(true).setNewFile(true).setPos(0).build();
        try {
            if (!segmentFile.init(opts)) {
                throw new IOException("Fail to create new segment file");
            }
            segmentFile.hintLoad();
            LOG.info("Create a new segment file {}.", (Object)segmentFile.getPath());
            return segmentFile;
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)new File(newSegPath));
            throw e;
        }
    }

    private String getNewSegmentFilePath() {
        return this.segmentsPath + File.separator + String.format("%019d", this.nextFileSequence.getAndIncrement()) + SEGMENT_FILE_POSFIX;
    }

    @Override
    protected void onSync() throws IOException, InterruptedException {
        SegmentFile lastSegmentFile = this.getLastSegmentFileForRead();
        if (lastSegmentFile != null) {
            lastSegmentFile.sync(this.isSync());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean onInitLoaded() {
        long startMs = Utils.monotonicMs();
        this.writeLock.lock();
        try {
            boolean normalExit;
            File segmentsDir = new File(this.segmentsPath);
            if (!this.ensureDir(segmentsDir)) {
                boolean bl = false;
                return bl;
            }
            CheckpointFile.Checkpoint checkpoint = this.loadCheckpoint();
            File[] segmentFiles = segmentsDir.listFiles((dir, name) -> SEGMENT_FILE_NAME_PATTERN.matcher(name).matches());
            boolean bl = normalExit = !this.abortFile.exists();
            if (!normalExit) {
                LOG.info("{} {} did not exit normally, will try to recover last file.", (Object)this.getServiceName(), (Object)this.segmentsPath);
            }
            this.segments = new ArrayList<SegmentFile>(segmentFiles == null ? 10 : segmentFiles.length);
            this.blankSegments = new ArrayDeque();
            ArrayList<File> corruptedHeaderSegments = new ArrayList<File>();
            if (segmentFiles != null && segmentFiles.length > 0) {
                boolean bl2;
                Arrays.sort(segmentFiles, Comparator.comparing(RocksDBSegmentLogStorage::getFileSequenceFromFileName));
                String checkpointSegFile = this.getCheckpointSegFilePath(checkpoint);
                for (int i = 0; i < segmentFiles.length; ++i) {
                    File segFile = segmentFiles[i];
                    this.nextFileSequence.set(RocksDBSegmentLogStorage.getFileSequenceFromFileName(segFile) + 1L);
                    SegmentFile segmentFile = new SegmentFile(this.maxSegmentFileSize, segFile.getAbsolutePath(), this.writeExecutor);
                    if (!segmentFile.mmapFile(false)) {
                        assert (segmentFile.isHeaderCorrupted());
                        corruptedHeaderSegments.add(segFile);
                        continue;
                    }
                    if (segmentFile.isBlank()) {
                        this.blankSegments.add(new AllocatedResult(segmentFile));
                        continue;
                    }
                    if (segmentFile.isHeaderCorrupted()) {
                        corruptedHeaderSegments.add(segFile);
                        continue;
                    }
                    this.segments.add(segmentFile);
                }
                if (!this.processCorruptedHeaderFiles(corruptedHeaderSegments)) {
                    bl2 = false;
                    return bl2;
                }
                if (!this.initBlankFiles()) {
                    bl2 = false;
                    return bl2;
                }
                if (!this.recoverFiles(checkpoint, normalExit, checkpointSegFile)) {
                    bl2 = false;
                    return bl2;
                }
            } else if (checkpoint != null) {
                LOG.warn("Missing segment files, checkpoint is: {}", (Object)checkpoint);
                boolean bl3 = false;
                return bl3;
            }
            LOG.info("{} Loaded {} segment files and  {} blank segment files from path {}.", new Object[]{this.getServiceName(), this.segments.size(), this.blankSegments.size(), this.segmentsPath});
            LOG.info("{} segments: \n{}", (Object)this.getServiceName(), (Object)this.descSegments());
            this.startCheckpointTask();
            if (normalExit) {
                if (!this.abortFile.create()) {
                    LOG.error("Fail to create abort file {}.", (Object)this.abortFile.getPath());
                    boolean bl4 = false;
                    return bl4;
                }
            } else {
                this.abortFile.touch();
            }
            this.startSegmentAllocator();
            boolean bl5 = true;
            return bl5;
        }
        catch (Exception e) {
            LOG.error("Fail to load segment files from directory {}.", (Object)this.segmentsPath, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            LOG.info("{} init and load cost {} ms.", (Object)this.getServiceName(), (Object)(Utils.monotonicMs() - startMs));
        }
    }

    private boolean recoverFiles(CheckpointFile.Checkpoint checkpoint, boolean normalExit, String checkpointSegFile) {
        boolean needRecover = false;
        SegmentFile prevFile = null;
        for (int i = 0; i < this.segments.size(); ++i) {
            boolean isLastFile = i == this.segments.size() - 1;
            SegmentFile segmentFile = this.segments.get(i);
            int pos = segmentFile.getSize();
            if (StringUtil.equalsIgnoreCase((String)checkpointSegFile, (String)segmentFile.getFilename())) {
                needRecover = true;
                assert (checkpoint != null);
                pos = checkpoint.committedPos;
            } else if (needRecover) {
                pos = 0;
            }
            SegmentFile.SegmentFileOptions opts = SegmentFile.SegmentFileOptions.builder().setSync(this.isSync()).setRecover(needRecover && !normalExit).setLastFile(isLastFile).setNewFile(false).setPos(pos).build();
            if (!segmentFile.init(opts)) {
                LOG.error("Fail to load segment file {}.", (Object)segmentFile.getPath());
                segmentFile.shutdown();
                return false;
            }
            if (segmentFile.getWrotePos() == 18 && !isLastFile) {
                LOG.error("Detected corrupted segment file {}.", (Object)segmentFile.getPath());
                return false;
            }
            if (prevFile != null) {
                prevFile.setLastLogIndex(segmentFile.getFirstLogIndex() - 1L);
            }
            prevFile = segmentFile;
        }
        if (this.getLastLogIndex() > 0L && prevFile != null) {
            prevFile.setLastLogIndex(this.getLastLogIndex());
        }
        return true;
    }

    private boolean initBlankFiles() {
        for (AllocatedResult ret : this.blankSegments) {
            SegmentFile segmentFile = ret.segmentFile;
            SegmentFile.SegmentFileOptions opts = SegmentFile.SegmentFileOptions.builder().setSync(false).setRecover(false).setLastFile(true).build();
            if (segmentFile.init(opts)) continue;
            LOG.error("Fail to load blank segment file {}.", (Object)segmentFile.getPath());
            segmentFile.shutdown();
            return false;
        }
        return true;
    }

    private boolean processCorruptedHeaderFiles(List<File> corruptedHeaderSegments) throws IOException {
        if (corruptedHeaderSegments.size() == 1) {
            File corruptedFile = corruptedHeaderSegments.get(0);
            if (RocksDBSegmentLogStorage.getFileSequenceFromFileName(corruptedFile) != this.nextFileSequence.get() - 1L) {
                LOG.error("Detected corrupted header segment file {}.", (Object)corruptedFile);
                return false;
            }
            LOG.warn("Truncate the last segment file {} which it's header is corrupted.", (Object)corruptedFile.getAbsolutePath());
            FileUtils.moveFile((File)corruptedFile, (File)new File(corruptedFile.getAbsolutePath() + ".corrupted"));
        } else if (corruptedHeaderSegments.size() > 1) {
            LOG.error("Detected corrupted header segment files: {}.", corruptedHeaderSegments);
            return false;
        }
        return true;
    }

    private void startSegmentAllocator() throws IOException {
        if (this.blankSegments.isEmpty()) {
            this.doAllocateSegment0();
        }
        this.segmentAllocator = new Thread(this::doAllocateSegment);
        this.segmentAllocator.setDaemon(true);
        this.segmentAllocator.setName("SegmentAllocator");
        this.segmentAllocator.start();
    }

    private void doAllocateSegment() {
        LOG.info("SegmentAllocator is started.");
        while (!Thread.currentThread().isInterrupted()) {
            this.doAllocateSegmentInLock();
            this.doSwapOutSegments(false);
        }
        LOG.info("SegmentAllocator exit.");
    }

    private void doAllocateSegmentInLock() {
        this.allocateLock.lock();
        try {
            while (this.blankSegments.size() >= this.preAllocateSegmentCount) {
                this.fullCond.await();
            }
            this.doAllocateSegment0();
            this.emptyCond.signal();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.blankSegments.add(new AllocatedResult(e));
            this.emptyCond.signal();
        }
        finally {
            this.allocateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSwapOutSegments(boolean force) {
        if (force) {
            this.readLock.lock();
        } else if (!this.readLock.tryLock()) {
            return;
        }
        try {
            int lastIndex;
            if (this.segments.size() <= this.keepInMemorySegmentCount) {
                return;
            }
            int segmentsInMemeCount = 0;
            int swappedOutCount = 0;
            long beginTime = Utils.monotonicMs();
            for (int i = lastIndex = this.segments.size() - 1; i >= 0; --i) {
                SegmentFile segFile = this.segments.get(i);
                if (segFile.isSwappedOut() || ++segmentsInMemeCount < this.keepInMemorySegmentCount || i == lastIndex) continue;
                segFile.hintUnload();
                segFile.swapOut();
                ++swappedOutCount;
            }
            LOG.info("Swapped out {} segment files, cost {} ms.", (Object)swappedOutCount, (Object)(Utils.monotonicMs() - beginTime));
        }
        catch (Exception e) {
            LOG.error("Fail to swap out segments.", (Throwable)e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void doAllocateSegment0() throws IOException {
        SegmentFile segFile = this.allocateNewSegmentFile();
        this.blankSegments.add(new AllocatedResult(segFile));
    }

    private static long getFileSequenceFromFileName(File file) {
        String name = file.getName();
        assert (name.endsWith(SEGMENT_FILE_POSFIX));
        int idx = name.indexOf(SEGMENT_FILE_POSFIX);
        return Long.valueOf(name.substring(0, idx));
    }

    private CheckpointFile.Checkpoint loadCheckpoint() {
        CheckpointFile.Checkpoint checkpoint;
        try {
            checkpoint = this.checkpointFile.load();
            if (checkpoint != null) {
                LOG.info("Loaded checkpoint: {} from {}.", (Object)checkpoint, (Object)this.checkpointFile.getPath());
            }
        }
        catch (IOException e) {
            LOG.error("Fail to load checkpoint file: {}", (Object)this.checkpointFile.getPath(), (Object)e);
            return null;
        }
        return checkpoint;
    }

    private boolean ensureDir(File segmentsDir) {
        try {
            FileUtils.forceMkdir((File)segmentsDir);
            return true;
        }
        catch (IOException e) {
            LOG.error("Fail to create segments directory: {}", (Object)this.segmentsPath, (Object)e);
            return false;
        }
    }

    private String getCheckpointSegFilePath(CheckpointFile.Checkpoint checkpoint) {
        return checkpoint != null ? checkpoint.segFilename : null;
    }

    private void startCheckpointTask() {
        this.checkpointExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(this.getServiceName() + "-Checkpoint-Thread-", true));
        this.checkpointExecutor.scheduleAtFixedRate(this::doCheckpoint, this.checkpointIntervalMs, this.checkpointIntervalMs, TimeUnit.MILLISECONDS);
        LOG.info("{} started checkpoint task.", (Object)this.getServiceName());
    }

    private StringBuilder descSegments() {
        StringBuilder segmentsDesc = new StringBuilder("[\n");
        for (SegmentFile segFile : this.segments) {
            segmentsDesc.append("  ").append(segFile.toString()).append("\n");
        }
        segmentsDesc.append("]");
        return segmentsDesc;
    }

    private String getServiceName() {
        return this.getClass().getSimpleName();
    }

    private void stopSegmentAllocator() {
        this.segmentAllocator.interrupt();
        try {
            this.segmentAllocator.join(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onShutdown() {
        this.stopCheckpointTask();
        this.stopSegmentAllocator();
        List<SegmentFile> shutdownFiles = Collections.emptyList();
        this.writeLock.lock();
        try {
            this.doCheckpoint();
            shutdownFiles = new ArrayList<SegmentFile>(this.segments);
            this.segments.clear();
            if (!this.abortFile.destroy()) {
                LOG.error("Fail to delete abort file {}.", (Object)this.abortFile.getPath());
            }
        }
        finally {
            this.writeLock.unlock();
            for (SegmentFile segmentFile : shutdownFiles) {
                segmentFile.shutdown();
            }
            this.shutdownBlankSegments();
        }
        this.writeExecutor.shutdown();
    }

    private void shutdownBlankSegments() {
        this.allocateLock.lock();
        try {
            for (AllocatedResult ret : this.blankSegments) {
                if (ret.segmentFile == null) continue;
                ret.segmentFile.shutdown();
            }
        }
        finally {
            this.allocateLock.unlock();
        }
    }

    private void stopCheckpointTask() {
        if (this.checkpointExecutor != null) {
            this.checkpointExecutor.shutdownNow();
            try {
                this.checkpointExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOG.info("{} stopped checkpoint task.", (Object)this.getServiceName());
        }
    }

    private void doCheckpoint() {
        SegmentFile lastSegmentFile = null;
        try {
            lastSegmentFile = this.getLastSegmentFileForRead();
            if (lastSegmentFile != null) {
                this.checkpointFile.save(new CheckpointFile.Checkpoint(lastSegmentFile.getFilename(), lastSegmentFile.getCommittedPos()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.error("Fatal error, fail to do checkpoint, last segment file is {}.", (Object)(lastSegmentFile != null ? lastSegmentFile.getPath() : "null"), (Object)e);
        }
    }

    public SegmentFile getLastSegmentFileForRead() throws IOException, InterruptedException {
        return this.getLastSegmentFile(-1L, 0, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReset(long nextLogIndex) {
        ArrayList<SegmentFile> destroyedFiles = new ArrayList<SegmentFile>();
        this.writeLock.lock();
        try {
            this.checkpointFile.destroy();
            destroyedFiles.addAll(this.segments);
            this.segments.clear();
            LOG.info("Destroyed segments and checkpoint in path {} by resetting.", (Object)this.segmentsPath);
        }
        finally {
            this.writeLock.unlock();
            for (SegmentFile segFile : destroyedFiles) {
                segFile.destroy();
            }
        }
    }

    private SegmentFile getLastSegmentWithoutLock() {
        return this.segments.get(this.segments.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onTruncatePrefix(long startIndex, long firstIndexKept) throws RocksDBException, IOException {
        ArrayList<SegmentFile> destroyedFiles = null;
        this.writeLock.lock();
        try {
            int fromIndex = this.binarySearchFileIndexByLogIndex(startIndex);
            int toIndex = this.binarySearchFileIndexByLogIndex(firstIndexKept);
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex < 0) {
                if (!this.segments.isEmpty() && this.getLastSegmentWithoutLock().getLastLogIndex() < firstIndexKept) {
                    toIndex = this.segments.size();
                } else {
                    LOG.warn("Segment file not found by logIndex={} to be truncate_prefix, current segments:\n{}.", (Object)firstIndexKept, (Object)this.descSegments());
                    return;
                }
            }
            List<SegmentFile> removedFiles = this.segments.subList(fromIndex, toIndex);
            destroyedFiles = new ArrayList<SegmentFile>(removedFiles);
            removedFiles.clear();
            this.doCheckpoint();
        }
        finally {
            this.writeLock.unlock();
            if (destroyedFiles != null) {
                for (SegmentFile segmentFile : destroyedFiles) {
                    segmentFile.destroy();
                }
            }
        }
    }

    private boolean isMetadata(byte[] data) {
        for (int offset = 0; offset < SegmentFile.RECORD_MAGIC_BYTES_SIZE; ++offset) {
            if (data[offset] == SegmentFile.RECORD_MAGIC_BYTES[offset]) continue;
            return false;
        }
        return true;
    }

    private SegmentFile getFirstSegmentWithoutLock() {
        return this.segments.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onTruncateSuffix(long lastIndexKept) throws RocksDBException, IOException {
        ArrayList<SegmentFile> destroyedFiles = null;
        this.writeLock.lock();
        try {
            byte[] keptData;
            byte[] data;
            int keptFileIndex = this.binarySearchFileIndexByLogIndex(lastIndexKept);
            int toIndex = this.binarySearchFileIndexByLogIndex(this.getLastLogIndex());
            if (keptFileIndex < 0) {
                if (!this.segments.isEmpty()) {
                    long firstLogIndex = this.getFirstSegmentWithoutLock().getFirstLogIndex();
                    if (firstLogIndex > lastIndexKept) {
                        List<SegmentFile> removedFiles = this.segments.subList(0, this.segments.size());
                        destroyedFiles = new ArrayList<SegmentFile>(removedFiles);
                        removedFiles.clear();
                    }
                    LOG.info("Truncating all segments in {} because the first log index {} is greater than lastIndexKept={}", new Object[]{this.segmentsPath, firstLogIndex, lastIndexKept});
                }
                LOG.warn("Segment file not found by logIndex={} to be truncate_suffix, current segments:\n{}.", (Object)lastIndexKept, (Object)this.descSegments());
                return;
            }
            if (toIndex < 0) {
                toIndex = this.segments.size() - 1;
            }
            List<SegmentFile> removedFiles = this.segments.subList(keptFileIndex + 1, toIndex + 1);
            destroyedFiles = new ArrayList<SegmentFile>(removedFiles);
            removedFiles.clear();
            SegmentFile keptFile = this.segments.get(keptFileIndex);
            if (keptFile.isBlank()) {
                return;
            }
            int logWrotePos = -1;
            long nextIndex = lastIndexKept + 1L;
            long endIndex = Math.min(this.getLastLogIndex(), keptFile.getLastLogIndex());
            while (nextIndex <= endIndex && (data = this.getValueFromRocksDB(this.getKeyBytes(nextIndex))) != null) {
                if (data.length == LOCATION_METADATA_SIZE) {
                    if (!this.isMetadata(data)) {
                        ++nextIndex;
                        continue;
                    }
                    logWrotePos = this.getWrotePosition(data);
                    break;
                }
                ++nextIndex;
            }
            if (logWrotePos < 0 && !this.isMetadata(keptData = this.getValueFromRocksDB(this.getKeyBytes(lastIndexKept)))) {
                long prevIndex = lastIndexKept - 1L;
                long startIndex = keptFile.getFirstLogIndex();
                while (prevIndex >= startIndex) {
                    byte[] data2 = this.getValueFromRocksDB(this.getKeyBytes(prevIndex));
                    if (data2 != null) {
                        if (data2.length == LOCATION_METADATA_SIZE) {
                            if (!this.isMetadata(data2)) {
                                --prevIndex;
                                continue;
                            }
                            logWrotePos = this.getWrotePosition(data2);
                            byte[] logData = this.onDataGet(prevIndex, data2);
                            logWrotePos += SegmentFile.getWriteBytes(logData);
                            break;
                        }
                        --prevIndex;
                        continue;
                    }
                    LOG.warn("Log entry not found at index={} when truncating logs suffix from lastIndexKept={}.", (Object)prevIndex, (Object)lastIndexKept);
                    --prevIndex;
                }
            }
            if (logWrotePos >= 0 && logWrotePos < keptFile.getSize()) {
                keptFile.truncateSuffix(logWrotePos, lastIndexKept, this.isSync());
            }
            this.doCheckpoint();
        }
        finally {
            this.writeLock.unlock();
            if (destroyedFiles != null) {
                for (SegmentFile segmentFile : destroyedFiles) {
                    segmentFile.destroy();
                }
            }
        }
    }

    private int getWrotePosition(byte[] data) {
        return Bits.getInt(data, SegmentFile.RECORD_MAGIC_BYTES_SIZE + 2 + 8);
    }

    @Override
    protected RocksDBLogStorage.WriteContext newWriteContext() {
        return new BarrierWriteContext();
    }

    @Override
    protected byte[] onDataAppend(long logIndex, byte[] value, RocksDBLogStorage.WriteContext ctx) throws IOException, InterruptedException {
        int waitToWroteBytes = SegmentFile.getWriteBytes(value);
        SegmentFile lastSegmentFile = this.getLastSegmentFile(logIndex, waitToWroteBytes, true, ctx);
        if (lastSegmentFile.reachesFileEndBy(waitToWroteBytes)) {
            throw new IOException("Too large value size: " + value.length + ", maxSegmentFileSize=" + this.maxSegmentFileSize);
        }
        if (value.length < this.valueSizeThreshold) {
            lastSegmentFile.setLastLogIndex(logIndex);
            ctx.finishJob();
            return value;
        }
        int pos = lastSegmentFile.write(logIndex, value, ctx);
        long firstLogIndex = lastSegmentFile.getFirstLogIndex();
        return this.encodeLocationMetadata(firstLogIndex, pos);
    }

    private byte[] encodeLocationMetadata(long firstLogIndex, int pos) {
        byte[] newData = new byte[LOCATION_METADATA_SIZE];
        System.arraycopy(SegmentFile.RECORD_MAGIC_BYTES, 0, newData, 0, SegmentFile.RECORD_MAGIC_BYTES_SIZE);
        Bits.putLong(newData, SegmentFile.RECORD_MAGIC_BYTES_SIZE + 2, firstLogIndex);
        Bits.putInt(newData, SegmentFile.RECORD_MAGIC_BYTES_SIZE + 2 + 8, pos);
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int binarySearchFileIndexByLogIndex(long logIndex) {
        this.readLock.lock();
        try {
            if (this.segments.isEmpty()) {
                int n = -1;
                return n;
            }
            if (this.segments.size() == 1) {
                SegmentFile firstFile = this.segments.get(0);
                if (firstFile.contains(logIndex)) {
                    int n = 0;
                    return n;
                }
                int n = -1;
                return n;
            }
            int low = 0;
            int high = this.segments.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                SegmentFile file = this.segments.get(mid);
                if (file.getLastLogIndex() < logIndex) {
                    low = mid + 1;
                    continue;
                }
                if (file.getFirstLogIndex() > logIndex) {
                    high = mid - 1;
                    continue;
                }
                int n = mid;
                return n;
            }
            int n = -(low + 1);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentFile binarySearchFileByFirstLogIndex(long logIndex) {
        this.readLock.lock();
        try {
            if (this.segments.isEmpty()) {
                SegmentFile segmentFile = null;
                return segmentFile;
            }
            if (this.segments.size() == 1) {
                SegmentFile firstFile = this.segments.get(0);
                if (firstFile.getFirstLogIndex() == logIndex) {
                    SegmentFile segmentFile = firstFile;
                    return segmentFile;
                }
                SegmentFile segmentFile = null;
                return segmentFile;
            }
            int low = 0;
            int high = this.segments.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                SegmentFile file = this.segments.get(mid);
                if (file.getFirstLogIndex() < logIndex) {
                    low = mid + 1;
                    continue;
                }
                if (file.getFirstLogIndex() > logIndex) {
                    high = mid - 1;
                    continue;
                }
                SegmentFile segmentFile = file;
                return segmentFile;
            }
            SegmentFile segmentFile = null;
            return segmentFile;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected byte[] onDataGet(long logIndex, byte[] value) throws IOException {
        int offset;
        if (value == null || value.length != LOCATION_METADATA_SIZE) {
            return value;
        }
        for (offset = 0; offset < SegmentFile.RECORD_MAGIC_BYTES_SIZE; ++offset) {
            if (value[offset] == SegmentFile.RECORD_MAGIC_BYTES[offset]) continue;
            return value;
        }
        long firstLogIndex = Bits.getLong(value, offset += 2);
        int pos = Bits.getInt(value, offset + 8);
        SegmentFile file = this.binarySearchFileByFirstLogIndex(firstLogIndex);
        if (file == null) {
            return null;
        }
        return file.read(logIndex, pos);
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_VALUE_SIZE_THRESHOLD;
    }

    static /* synthetic */ int access$100() {
        return MAX_SEGMENT_FILE_SIZE;
    }

    static /* synthetic */ int access$200() {
        return DEFAULT_CHECKPOINT_INTERVAL_MS;
    }

    public static class Builder {
        private String path;
        private RaftOptions raftOptions;
        private int valueSizeThreshold = RocksDBSegmentLogStorage.access$000();
        private int maxSegmentFileSize = RocksDBSegmentLogStorage.access$100();
        private ThreadPoolExecutor writeExecutor;
        private int preAllocateSegmentCount = 2;
        private int keepInMemorySegmentCount = 3;
        private int checkpointIntervalMs = RocksDBSegmentLogStorage.access$200();

        public String getPath() {
            return this.path;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public RaftOptions getRaftOptions() {
            return this.raftOptions;
        }

        public Builder setRaftOptions(RaftOptions raftOptions) {
            this.raftOptions = raftOptions;
            return this;
        }

        public int getValueSizeThreshold() {
            return this.valueSizeThreshold;
        }

        public Builder setValueSizeThreshold(int valueSizeThreshold) {
            this.valueSizeThreshold = valueSizeThreshold;
            return this;
        }

        public int getMaxSegmentFileSize() {
            return this.maxSegmentFileSize;
        }

        public Builder setMaxSegmentFileSize(int maxSegmentFileSize) {
            this.maxSegmentFileSize = maxSegmentFileSize;
            return this;
        }

        public ThreadPoolExecutor getWriteExecutor() {
            return this.writeExecutor;
        }

        public Builder setWriteExecutor(ThreadPoolExecutor writeExecutor) {
            this.writeExecutor = writeExecutor;
            return this;
        }

        public int getPreAllocateSegmentCount() {
            return this.preAllocateSegmentCount;
        }

        public Builder setPreAllocateSegmentCount(int preAllocateSegmentCount) {
            this.preAllocateSegmentCount = preAllocateSegmentCount;
            return this;
        }

        public int getKeepInMemorySegmentCount() {
            return this.keepInMemorySegmentCount;
        }

        public Builder setKeepInMemorySegmentCount(int keepInMemorySegmentCount) {
            this.keepInMemorySegmentCount = keepInMemorySegmentCount;
            return this;
        }

        public int getCheckpointIntervalMs() {
            return this.checkpointIntervalMs;
        }

        public Builder setCheckpointIntervalMs(int checkpointIntervalMs) {
            this.checkpointIntervalMs = checkpointIntervalMs;
            return this;
        }

        public RocksDBSegmentLogStorage build() {
            return new RocksDBSegmentLogStorage(this.path, this.raftOptions, this.valueSizeThreshold, this.maxSegmentFileSize, this.preAllocateSegmentCount, this.keepInMemorySegmentCount, this.checkpointIntervalMs, this.writeExecutor);
        }
    }

    public static class BarrierWriteContext
    implements RocksDBLogStorage.WriteContext {
        private final CountDownEvent events = new CountDownEvent();
        private volatile Exception e;
        private volatile List<Runnable> hooks;

        @Override
        public void startJob() {
            this.events.incrementAndGet();
        }

        @Override
        public synchronized void addFinishHook(Runnable r) {
            if (this.hooks == null) {
                this.hooks = new CopyOnWriteArrayList<Runnable>();
            }
            this.hooks.add(r);
        }

        @Override
        public void finishJob() {
            this.events.countDown();
        }

        @Override
        public void setError(Exception e) {
            this.e = e;
        }

        @Override
        public void joinAll() throws InterruptedException, IOException {
            this.events.await();
            if (this.hooks != null) {
                for (Runnable r : this.hooks) {
                    r.run();
                }
            }
            if (this.e != null) {
                throw new IOException("Fail to apppend entries", this.e);
            }
        }
    }

    private static class AllocatedResult {
        SegmentFile segmentFile;
        IOException ie;

        public AllocatedResult(SegmentFile segmentFile) {
            this.segmentFile = segmentFile;
        }

        public AllocatedResult(IOException ie) {
            this.ie = ie;
        }
    }
}

