/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlpcn.commons.lang.util.CollectionUtil;
import org.nlpcn.commons.lang.util.MapCount;

public class WordWeight {
    private MapCount<String> mc = new MapCount();
    private HashMap<String, MapCount<String>> x2mat = new HashMap();
    private MapCount<String> x2mc = new MapCount();
    private Integer maxCount;
    private Integer recyclingCount;
    private double allFreq;

    public WordWeight() {
    }

    public WordWeight(Integer maxCount, Integer recyclingCount) {
        this.maxCount = maxCount;
        this.recyclingCount = recyclingCount;
    }

    public void add(String word) {
        this.add(word, 1.0);
    }

    public void add(String word, double weight) {
        this.allFreq += weight;
        this.mc.add(word, weight);
        if (this.maxCount != null && this.recyclingCount != null && this.mc.get().size() >= this.maxCount) {
            this.recycling();
        }
    }

    public void add(String word, String target) {
        this.add(word, target, 1.0);
    }

    public void add(String word, String target, double weight) {
        if (this.x2mat.containsKey(target)) {
            this.x2mat.get(target).add(word, weight);
        } else {
            this.x2mat.put(target, new MapCount());
            this.x2mat.get(target).add(word, weight);
        }
        this.x2mc.add(target, 1);
        this.add(word, weight);
    }

    public Map<String, Double> export() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        result.putAll(this.mc.get());
        return result;
    }

    public Map<String, Double> exportIDF() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : this.mc.get().entrySet()) {
            result.put(entry.getKey(), Math.log(this.allFreq / entry.getValue()));
        }
        return result;
    }

    public HashMap<String, MapCount<String>> exportChiSquare() {
        HashMap<String, MapCount<String>> x2final = new HashMap<String, MapCount<String>>();
        double sum = this.allFreq;
        for (Map.Entry<String, MapCount<String>> iter1 : this.x2mat.entrySet()) {
            String target = iter1.getKey();
            for (Map.Entry<String, Double> iter2 : iter1.getValue().get().entrySet()) {
                String name = iter2.getKey();
                Double a = iter2.getValue();
                Double b = this.x2mc.get().get(target) - a;
                Double c = this.mc.get().get(name) - a;
                Double d = sum - b - c + a;
                Double x2stat = Math.pow(a * d - b * c, 2.0) / (a + c) / (b + d);
                if (x2final.get(target) != null) {
                    x2final.get(target).add(name, x2stat);
                    continue;
                }
                x2final.put(target, new MapCount());
                x2final.get(target).add(name, x2stat);
            }
        }
        return x2final;
    }

    private void recycling() {
        List<Map.Entry<String, Double>> list = CollectionUtil.sortMapByValue(this.mc.get(), -1);
        Set<String> targetSet = this.x2mat.keySet();
        for (int i = 0; i < this.recyclingCount; ++i) {
            String word = list.get(i).getKey();
            this.allFreq -= this.mc.get().remove(word).doubleValue();
            for (String target : targetSet) {
                Double r2 = this.x2mat.get(target).get().remove(word);
                if (r2 == null) continue;
                this.x2mc.add(target, -r2.doubleValue());
            }
        }
    }
}

