/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class FileFinder {
    private static final Log LOG = LogFactory.getLog();
    private static final String SEPARATOR = System.getProperty("path.separator");
    private static final String[] PATHS_PROPERTIES = new String[]{"java.class.path", "java.library.path"};
    public static List<File> fileDir = new ArrayList<File>();

    public static File find(String lastPath) {
        return FileFinder.find(lastPath, Integer.MAX_VALUE);
    }

    public static File find(String lastPath, int deep) {
        for (File file : fileDir) {
            if (!file.exists() || !file.canRead() || (file = FileFinder.findByFile(file, lastPath, deep)) == null) continue;
            return file;
        }
        for (String pathProperties : PATHS_PROPERTIES) {
            String[] propertyPath;
            for (String path : propertyPath = System.getProperty(pathProperties).split(SEPARATOR)) {
                File file = new File(path);
                try {
                    if (!file.canRead() || !file.exists() || (file = FileFinder.findByFile(file, lastPath, deep)) == null) continue;
                    return file;
                }
                catch (AccessControlException e) {
                    LOG.info(path + " not access to visit");
                }
            }
        }
        return null;
    }

    public static File findByFile(File file, String lastPath) {
        return FileFinder.findByFile(file, lastPath, Integer.MAX_VALUE);
    }

    public static File findByFile(File file, String lastPath, int deep) {
        File[] listFiles;
        if (deep == 0 || !file.exists() || !file.canRead()) {
            return null;
        }
        if (file.getAbsolutePath().endsWith(lastPath)) {
            return file;
        }
        if (file.isDirectory() && (listFiles = file.listFiles()) != null && listFiles.length > 0) {
            for (File file2 : listFiles) {
                File temp = FileFinder.findByFile(file2, lastPath, deep - 1);
                if (temp == null) continue;
                return temp;
            }
        }
        return null;
    }

    static {
        fileDir.add(new File("").getAbsoluteFile());
    }
}

