/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgPageSize;
import org.apache.hugegraph.store.HgSeekAble;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.GrpcUtil;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.util.HgBufferProxy;
import org.apache.hugegraph.store.client.util.HgStoreClientConfig;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.client.util.HgStoreClientUtil;
import org.apache.hugegraph.store.client.util.MetricX;
import org.apache.hugegraph.store.grpc.common.Header;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.common.ScanMethod;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.apache.hugegraph.store.grpc.stream.KvPageRes;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.grpc.stream.SelectParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class KvPageScanner
implements KvCloseableIterator<Kv>,
HgPageSize,
HgSeekAble {
    private static final Logger log = LoggerFactory.getLogger(KvPageScanner.class);
    private static final HgStoreClientConfig clientConfig = HgStoreClientConfig.of();
    private static final int nextTimeout = clientConfig.getNetKvScannerHaveNextTimeout();
    private final HgStoreNodeSession session;
    private final HgStoreStreamGrpc.HgStoreStreamStub stub;
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final SelectParam.Builder selectBuilder = SelectParam.newBuilder();
    private final BlockingQueue<ScanStreamReq> reqQueue = new LinkedBlockingQueue<ScanStreamReq>();
    private int pageSize = clientConfig.getNetKvScannerPageSize();
    private HgBufferProxy<List<Kv>> proxy;
    private Iterator<Kv> iterator;
    private StreamObserver<ScanStreamReq> observer;
    private ScanStreamReq.Builder reqBuilder = ScanStreamReq.newBuilder();
    private boolean in = true;
    private byte[] nodePosition = HgStoreClientConst.EMPTY_BYTES;

    private KvPageScanner(ScanMethod scanMethod, HgStoreNodeSession session, HgStoreStreamGrpc.HgStoreStreamStub stub, String table, HgOwnerKey prefix, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int partition, int scanType, byte[] query) {
        this.session = session;
        this.stub = stub;
        this.pageSize = clientConfig.getNetKvScannerPageSize();
        this.reqBuilder.setHeader(this.getHeader(this.session)).setMethod(scanMethod).setTable(table).setStart(KvPageScanner.toBs(KvPageScanner.toOk(startKey).getKey())).setEnd(KvPageScanner.toBs(KvPageScanner.toOk(endKey).getKey())).setLimit(limit <= 0L ? Integer.MAX_VALUE : limit).setPrefix(KvPageScanner.toBs(KvPageScanner.toOk(prefix).getKey())).setCode(partition).setScanType(scanType).setQuery(KvPageScanner.toBs(query != null ? query : HgStoreClientConst.EMPTY_BYTES)).setPageSize(this.pageSize).setPosition(KvPageScanner.toBs(this.nodePosition));
        this.init();
    }

    public KvPageScanner(HgStoreNodeSession session, HgStoreStreamGrpc.HgStoreStreamStub stub, ScanStreamReq.Builder reqBuilder) {
        this.session = session;
        this.stub = stub;
        reqBuilder.setPageSize(this.pageSize);
        reqBuilder.setPosition(KvPageScanner.toBs(this.nodePosition));
        this.reqBuilder = reqBuilder;
        this.init();
    }

    public static KvCloseableIterator<Kv> scanAll(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamStub stub, String table, long limit, byte[] query) {
        return new KvPageScanner(ScanMethod.ALL, nodeSession, stub, table, null, null, null, limit, -1, 128, query);
    }

    public static KvCloseableIterator<Kv> scanPrefix(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamStub stub, String table, HgOwnerKey prefix, long limit, byte[] query) {
        return new KvPageScanner(ScanMethod.PREFIX, nodeSession, stub, table, prefix, null, null, limit, prefix.getKeyCode(), 1, query);
    }

    public static KvCloseableIterator<Kv> scanRange(HgStoreNodeSession nodeSession, HgStoreStreamGrpc.HgStoreStreamStub stub, String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int scanType, byte[] query) {
        return new KvPageScanner(ScanMethod.RANGE, nodeSession, stub, table, null, startKey, endKey, limit, startKey.getKeyCode(), scanType, query);
    }

    static HgOwnerKey toOk(HgOwnerKey key) {
        return key == null ? HgStoreClientConst.EMPTY_OWNER_KEY : key;
    }

    static ByteString toBs(byte[] bytes) {
        return ByteString.copyFrom((byte[])(bytes != null ? bytes : HgStoreClientConst.EMPTY_BYTES));
    }

    private ScanStreamReq createScanReq() {
        return this.reqBuilder.setPosition(KvPageScanner.toBs(this.nodePosition)).build();
    }

    private ScanStreamReq createStopReq() {
        return this.reqBuilder.setHeader(this.getHeader(this.session)).setCloseFlag(1).build();
    }

    private void init() {
        this.proxy = HgBufferProxy.of(() -> this.serverScan());
        this.observer = this.stub.scan((StreamObserver)new ServeObserverImpl());
    }

    private void serverScan() {
        if (this.completed.get()) {
            this.proxy.close();
            return;
        }
        if (this.proxy.isClosed()) {
            return;
        }
        this.send(this.createScanReq());
    }

    private void stopSever() {
        this.send(this.createStopReq());
    }

    private void send(ScanStreamReq req) {
        if (!this.completed.get()) {
            try {
                this.observer.onNext((Object)req);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
            }
            catch (Exception e) {
                throw e;
            }
        }
    }

    private void clientError(String msg) {
        this.observer.onError((Throwable)GrpcUtil.toErr(msg));
    }

    @Override
    public boolean hasNext() {
        if (!this.in) {
            return false;
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            return true;
        }
        long start = 0L;
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            start = System.nanoTime();
        }
        List<Kv> data = this.proxy.receive(nextTimeout, sec -> {
            String msg = "failed to receive data from net scanning, because of timeout [ " + sec + " ] sec.";
            log.error(msg);
            this.clientError(msg);
            throw new RuntimeException(msg);
        });
        if (debugEnabled) {
            MetricX.plusIteratorWait(System.nanoTime() - start);
        }
        this.iterator = data != null ? data.iterator() : Collections.emptyIterator();
        return this.iterator.hasNext();
    }

    @Override
    public Kv next() {
        if (this.iterator == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iterator.next();
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean isPageEmpty() {
        return !this.iterator.hasNext();
    }

    @Override
    public byte[] position() {
        return HgStoreClientUtil.toBytes(this.session.getStoreNode().getNodeId());
    }

    @Override
    public void seek(byte[] position) {
        if (position == null || position.length < 8) {
            return;
        }
        byte[] nodeIdBytes = new byte[8];
        System.arraycopy(position, 0, nodeIdBytes, 0, 8);
        long nodeId = this.session.getStoreNode().getNodeId();
        long pId = HgStoreClientUtil.toLong(nodeIdBytes);
        boolean bl = this.in = nodeId >= pId;
        if (this.in && nodeId == pId) {
            this.nodePosition = new byte[position.length - 8];
            System.arraycopy(position, 8, this.nodePosition, 0, this.nodePosition.length);
        } else {
            this.nodePosition = HgStoreClientConst.EMPTY_BYTES;
        }
    }

    @Override
    public void close() {
        this.stopSever();
    }

    private Header getHeader(HgStoreNodeSession nodeSession) {
        return Header.newBuilder().setGraph(nodeSession.getGraphName()).build();
    }

    private class ServeObserverImpl
    implements StreamObserver<KvPageRes> {
        private ServeObserverImpl() {
        }

        public void onNext(KvPageRes value) {
            if (value.getOver()) {
                KvPageScanner.this.completed.set(true);
                KvPageScanner.this.observer.onCompleted();
            }
            KvPageScanner.this.proxy.send(value.getDataList());
            if (KvPageScanner.this.completed.get()) {
                KvPageScanner.this.proxy.close();
            }
        }

        public void onError(Throwable t) {
            KvPageScanner.this.completed.set(true);
            try {
                KvPageScanner.this.observer.onCompleted();
            }
            catch (Exception e) {
                log.warn("failed to invoke requestObserver.onCompleted(), reason:", (Object)e.getMessage());
            }
            KvPageScanner.this.proxy.close();
            KvPageScanner.this.proxy.setError(t);
            log.error("failed to complete scan of session: " + KvPageScanner.this.session, t);
        }

        public void onCompleted() {
            KvPageScanner.this.completed.set(true);
            KvPageScanner.this.proxy.close();
        }
    }
}

