/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.store.client.HgPrivate;
import org.apache.hugegraph.store.client.HgStoreNode;
import org.apache.hugegraph.store.client.HgStoreNodeBuilder;
import org.apache.hugegraph.store.client.HgStoreNodeManager;
import org.apache.hugegraph.store.client.grpc.GrpcStoreNodeImpl;
import org.apache.hugegraph.store.client.grpc.GrpcStoreSessionClient;
import org.apache.hugegraph.store.client.grpc.GrpcStoreStreamClient;
import org.apache.hugegraph.store.client.util.HgAssert;

public class GrpcStoreNodeBuilder
implements HgStoreNodeBuilder {
    private static final GrpcStoreSessionClient sessionClient = new GrpcStoreSessionClient();
    private static final GrpcStoreStreamClient streamClient = new GrpcStoreStreamClient();
    private static final AtomicLong ids = new AtomicLong(0L);
    private final HgStoreNodeManager nodeManager;
    private Long nodeId;
    private String address;

    public GrpcStoreNodeBuilder(HgStoreNodeManager nodeManager, HgPrivate hgPrivate) {
        HgAssert.isArgumentNotNull(hgPrivate, "hgPrivate");
        HgAssert.isArgumentNotNull(nodeManager, "nodeManager");
        this.nodeManager = nodeManager;
    }

    @Override
    public GrpcStoreNodeBuilder setAddress(String address) {
        HgAssert.isFalse(HgAssert.isInvalid(address), "The argument is invalid: address.");
        this.address = address;
        return this;
    }

    @Override
    public GrpcStoreNodeBuilder setNodeId(Long nodeId) {
        HgAssert.isFalse(nodeId == null, "The argument is invalid: nodeId.");
        this.nodeId = nodeId;
        return this;
    }

    @Override
    public HgStoreNode build() {
        if (this.nodeId == null) {
            this.nodeId = ids.addAndGet(-1L);
        }
        HgAssert.isFalse(this.nodeId == null, "nodeId can't to be null");
        HgAssert.isFalse(this.address == null, "address can't to be null");
        GrpcStoreNodeImpl node = new GrpcStoreNodeImpl(this.nodeManager, sessionClient, streamClient);
        node.setNodeId(this.nodeId);
        node.setAddress(this.address);
        return node;
    }
}

