/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgKvOrderedIterator;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.HgStoreSession;
import org.apache.hugegraph.store.client.HgNodePartition;
import org.apache.hugegraph.store.client.HgNodePartitionerBuilder;
import org.apache.hugegraph.store.client.HgStoreNode;
import org.apache.hugegraph.store.client.HgStoreNodeManager;
import org.apache.hugegraph.store.client.HgStoreNodePartitioner;
import org.apache.hugegraph.store.client.NodeTkv;
import org.apache.hugegraph.store.client.NodeTxExecutor;
import org.apache.hugegraph.store.client.SequencedIterator;
import org.apache.hugegraph.store.client.TopWorkIteratorProxy;
import org.apache.hugegraph.store.client.grpc.KvBatchScanner;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.util.HgAssert;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.client.util.HgStoreClientUtil;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.term.HgPair;
import org.apache.hugegraph.store.term.HgTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class NodeTxSessionProxy
implements HgStoreSession {
    private static final Logger log = LoggerFactory.getLogger(NodeTxSessionProxy.class);
    private final HgStoreNodeManager nodeManager;
    private final HgStoreNodePartitioner nodePartitioner;
    private final String graphName;
    private final NodeTxExecutor txExecutor;

    NodeTxSessionProxy(String graphName, HgStoreNodeManager nodeManager) {
        this.nodeManager = nodeManager;
        this.graphName = graphName;
        this.nodePartitioner = this.nodeManager.getNodePartitioner();
        this.txExecutor = NodeTxExecutor.graphOf(this.graphName, this);
        HgAssert.isFalse(this.nodePartitioner == null, "Failed to retrieve the node-partitioner from node-manager.");
    }

    @Override
    public void beginTx() {
        this.txExecutor.setTx(true);
    }

    @Override
    public void commit() {
        this.txExecutor.commitTx();
    }

    @Override
    public void rollback() {
        this.txExecutor.rollbackTx();
    }

    @Override
    public boolean isTx() {
        return this.txExecutor.isTx();
    }

    @Override
    public boolean put(String table, HgOwnerKey ownerKey, byte[] value) {
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)ownerKey, null), e -> e.getSession().put(table, e.getKey(), value));
    }

    @Override
    public boolean directPut(String table, int partitionId, HgOwnerKey ownerKey, byte[] value) {
        HgAssert.isArgumentValid(table, "table");
        HgAssert.isArgumentNotNull(ownerKey, "ownerKey");
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)ownerKey, (Object)partitionId), e -> e.getSession().put(table, e.getKey(), value));
    }

    @Override
    public boolean delete(String table, HgOwnerKey ownerKey) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(ownerKey == null, "The argument is invalid: ownerKey");
        if (log.isDebugEnabled()) {
            log.debug("delete -> graph: {}, table: {}, key: {}", new Object[]{this.graphName, table, HgStoreClientUtil.toStr(ownerKey)});
        }
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)ownerKey, null), e -> e.getSession().delete(table, e.getKey()));
    }

    @Override
    public boolean deleteSingle(String table, HgOwnerKey ownerKey) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(ownerKey == null, "The argument is invalid: ownerKey");
        if (log.isDebugEnabled()) {
            log.debug("deleteSingle -> graph: {}, table: {}, key: {}", new Object[]{this.graphName, table, HgStoreClientUtil.toStr(ownerKey)});
        }
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)ownerKey, null), e -> e.getSession().deleteSingle(table, e.getKey()));
    }

    @Override
    public boolean deletePrefix(String table, HgOwnerKey prefix) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(prefix == null, "The argument is invalid: prefix");
        if (log.isDebugEnabled()) {
            log.debug("deletePrefix -> graph: {}, table: {}, prefix: {}", new Object[]{this.graphName, table, HgStoreClientUtil.toStr(prefix)});
        }
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)prefix, null), e -> e.getSession().deletePrefix(table, e.getKey()));
    }

    @Override
    public boolean deleteRange(String table, HgOwnerKey start, HgOwnerKey end) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(start == null, "The argument is invalid: start");
        HgAssert.isFalse(end == null, "The argument is invalid: end");
        if (log.isDebugEnabled()) {
            log.debug("deleteRange -> graph: {}, table: {}, start: {}, end: {}", new Object[]{this.graphName, table, HgStoreClientUtil.toStr(start), HgStoreClientUtil.toStr(end)});
        }
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)start, (Object)end), e -> e.getSession().deleteRange(table, e.getKey(), e.getEndKey()));
    }

    @Override
    public boolean merge(String table, HgOwnerKey key, byte[] value) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(key == null, "The argument is invalid: key");
        HgAssert.isFalse(value == null, "The argument is invalid: value");
        if (log.isDebugEnabled()) {
            log.debug("merge -> graph: {}, table: {}, key: {}, value: {}", new Object[]{this.graphName, table, HgStoreClientUtil.toStr(key), HgStoreClientUtil.toStr(value)});
        }
        return this.txExecutor.prepareTx((HgTriple<String, HgOwnerKey, Object>)new HgTriple((Object)table, (Object)key, (Object)value), e -> e.getSession().merge(table, e.getKey(), value));
    }

    @Override
    public byte[] get(String table, HgOwnerKey ownerKey) {
        HgAssert.isArgumentValid(table, "table");
        HgAssert.isArgumentNotNull(ownerKey, "ownerKey");
        return this.txExecutor.limitOne(() -> this.getNodeStream(table, ownerKey), e -> e.session.get(table, ((NodeTkv)e.data).getKey()), HgStoreClientConst.EMPTY_BYTES);
    }

    @Override
    public boolean clean(int partId) {
        Collection<HgNodePartition> nodes = this.doPartition("", partId);
        return nodes.parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).clean(partId)).findFirst().get();
    }

    @Override
    @Deprecated
    public List<HgKvEntry> batchGetOwner(String table, List<HgOwnerKey> keyList) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(HgAssert.isInvalid(keyList), "The argument is invalid: keyList");
        return this.txExecutor.toList(l -> this.getStoreNode((Long)l), keyList, key -> this.toNodeTkvList(table, (HgOwnerKey)key, (HgOwnerKey)key).stream(), e -> e.session.batchGetOwner(table, (List)e.data));
    }

    @Override
    public HgKvIterator<HgKvEntry> batchPrefix(String table, List<HgOwnerKey> keyList) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(HgAssert.isInvalid(keyList), "The argument is invalid: keyList");
        return this.toHgKvIteratorProxy(this.txExecutor.toList(l -> this.getStoreNode((Long)l), keyList, key -> this.toNodeTkvList(table, (HgOwnerKey)key, (HgOwnerKey)key).stream(), e -> Collections.singletonList(e.session.batchPrefix(table, (List)e.data))), Long.MAX_VALUE);
    }

    @Override
    public boolean truncate() {
        return this.txExecutor.isAllTrue(() -> this.getNodeStream(""), e -> e.session.truncate());
    }

    @Override
    public boolean existsTable(String table) {
        return this.txExecutor.ifAnyTrue(() -> this.getNodeStream(""), e -> e.session.existsTable(table));
    }

    @Override
    public boolean createTable(String table) {
        return this.txExecutor.isAllTrue(() -> this.getNodeStream(""), e -> e.session.createTable(table));
    }

    @Override
    public boolean deleteTable(String table) {
        return this.txExecutor.isAllTrue(() -> this.getNodeStream(""), e -> e.session.deleteTable(table));
    }

    @Override
    public boolean dropTable(String table) {
        return this.txExecutor.isAllTrue(() -> this.getNodeStream(table), e -> e.session.dropTable(table));
    }

    @Override
    public boolean deleteGraph(String graph) {
        return this.txExecutor.isAllTrue(() -> this.getNodeStream(""), e -> e.session.deleteGraph(graph));
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table) {
        return this.scanIterator(table, 0L);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, byte[] query) {
        return this.scanIterator(table, 0L, query);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, long limit) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), limit)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, long limit, byte[] query) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey(), limit, query)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey keyPrefix) {
        return this.scanIterator(table, keyPrefix, 0L);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey keyPrefix, long limit) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(keyPrefix == null, "The argument is invalid: keyPrefix");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table, keyPrefix).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey(), limit)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey keyPrefix, long limit, byte[] query) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(keyPrefix == null, "The argument is invalid: keyPrefix");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table, keyPrefix).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey(), limit, query)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey startKey, HgOwnerKey endKey) {
        return this.scanIterator(table, startKey, endKey, 0L, null);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(startKey == null, "The argument is invalid: startKey");
        HgAssert.isFalse(endKey == null, "The argument is invalid: endKey");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table, startKey, endKey).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey(), e.getEndKey(), limit)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit, byte[] query) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(startKey == null, "The argument is invalid: startKey");
        HgAssert.isFalse(endKey == null, "The argument is invalid: endKey");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table, startKey, endKey).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey(), e.getEndKey(), limit, query)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int scanType, byte[] query) {
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        HgAssert.isFalse(startKey == null, "The argument is invalid: startKey");
        HgAssert.isFalse(endKey == null, "The argument is invalid: endKey");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table, startKey, endKey).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey(), e.getEndKey(), limit, scanType, query)).collect(Collectors.toList()), limit);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(String table, int codeFrom, int codeTo, int scanType, byte[] query) {
        if (log.isDebugEnabled()) {
            log.debug("graph: {}, table: {}, codeFrom: {}, codeTo: {}, scanType: {}, query: {}", new Object[]{this.graphName, table, codeFrom, codeTo, scanType, HgStoreClientUtil.toStr(query)});
        }
        HgAssert.isFalse(HgAssert.isInvalid(table), "The argument is invalid: table");
        return this.toHgKvIteratorProxy(this.toNodeTkvList(table, codeFrom, codeTo).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).scanIterator(e.getTable(), e.getKey().getKeyCode(), e.getEndKey().getKeyCode(), scanType, query)).collect(Collectors.toList()), 0L);
    }

    @Override
    public HgKvIterator<HgKvEntry> scanIterator(ScanStreamReq.Builder scanReqBuilder) {
        List<NodeTkv> nodeTKvs = this.toNodeTkvList(scanReqBuilder);
        Function<NodeTkv, HgKvIterator> hgKvIteratorFunction = e -> {
            HgStoreSession session = this.getStoreNode(e.getNodeId()).openSession(this.graphName);
            return session.scanIterator(scanReqBuilder);
        };
        List<HgKvIterator> iterators = nodeTKvs.parallelStream().map(hgKvIteratorFunction).collect(Collectors.toList());
        return this.toHgKvIteratorProxy(iterators, scanReqBuilder.getLimit());
    }

    @Override
    public long count(String table) {
        return this.toNodeTkvList(table).parallelStream().map(e -> this.getStoreNode(e.getNodeId()).openSession(this.graphName).count(e.getTable())).collect(Collectors.summingLong(l -> l));
    }

    @Override
    public List<HgKvIterator<HgKvEntry>> scanBatch(HgScanQuery scanQuery) {
        HgAssert.isArgumentNotNull(scanQuery, "scanQuery");
        return this.toTkvMapFunc(scanQuery.getScanMethod()).apply(scanQuery).entrySet().stream().map(e -> this.getStoreNode((Long)e.getKey()).openSession(this.graphName).scanBatch(this.toScanQueryFunc(scanQuery.getScanMethod()).apply(scanQuery.getTable(), (List)e.getValue()).setQuery(scanQuery.getQuery()).setLimit(scanQuery.getLimit()).setPerKeyLimit(scanQuery.getPerKeyLimit()).setPerKeyMax(scanQuery.getPerKeyMax()).setScanType(scanQuery.getScanType()).build())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public KvCloseableIterator<HgKvIterator<HgKvEntry>> scanBatch2(HgScanQuery scanQuery) {
        return this.scanBatch3(scanQuery, null);
    }

    @Override
    public KvCloseableIterator<HgKvIterator<HgKvEntry>> scanBatch3(HgScanQuery scanQuery, KvCloseableIterator iterator) {
        KvCloseableIterator notifierWrap = KvBatchScanner.ofMerger(scanQuery, (query, notifier) -> {
            Map<Long, List<NodeTkv>> nodeTkvs = this.toTkvMapFunc(scanQuery.getScanMethod()).apply((HgScanQuery)query);
            nodeTkvs.forEach((storeId, tkvs) -> this.getStoreNode((Long)storeId).openSession(this.graphName).scanBatch3(this.toScanQueryFunc(scanQuery.getScanMethod()).apply(scanQuery.getTable(), (List<NodeTkv>)tkvs).setQuery(scanQuery.getQuery()).setLimit(scanQuery.getLimit()).setSkipDegree(scanQuery.getSkipDegree()).setPerKeyLimit(scanQuery.getPerKeyLimit()).setPerKeyMax(scanQuery.getPerKeyMax()).setScanType(scanQuery.getScanType()).setOrderType(scanQuery.getOrderType()).build(), (KvCloseableIterator)notifier));
            return true;
        });
        return notifierWrap;
    }

    private Function<HgScanQuery, Map<Long, List<NodeTkv>>> toTkvMapFunc(HgScanQuery.ScanMethod scanMethod) {
        switch (scanMethod) {
            case RANGE: {
                return scanQuery -> {
                    List<HgOwnerKey> starts = scanQuery.getStartList();
                    List<HgOwnerKey> ends = scanQuery.getEndList();
                    int size = starts.size();
                    return IntStream.range(0, size).boxed().map(i -> this.toNodeTkvList(scanQuery.getTable(), (HgOwnerKey)starts.get((int)i), (HgOwnerKey)ends.get((int)i))).flatMap(Collection::stream).collect(Collectors.groupingBy(NodeTkv::getNodeId));
                };
            }
            case PREFIX: {
                return scanQuery -> scanQuery.getPrefixList().stream().map(keyPrefix -> this.toNodeTkvList(scanQuery.getTable(), (HgOwnerKey)keyPrefix)).flatMap(Collection::stream).collect(Collectors.groupingBy(NodeTkv::getNodeId));
            }
        }
        return scanQuery -> this.toNodeTkvList(scanQuery.getTable()).stream().collect(Collectors.groupingBy(NodeTkv::getNodeId));
    }

    private BiFunction<String, List<NodeTkv>, HgScanQuery.ScanBuilder> toScanQueryFunc(HgScanQuery.ScanMethod scanMethod) {
        switch (scanMethod) {
            case RANGE: {
                return (table, tkvList) -> {
                    LinkedList<HgOwnerKey> startList = new LinkedList<HgOwnerKey>();
                    LinkedList<HgOwnerKey> endList = new LinkedList<HgOwnerKey>();
                    tkvList.stream().forEach(e -> {
                        startList.add(e.getKey());
                        endList.add(e.getEndKey());
                    });
                    return HgScanQuery.ScanBuilder.rangeOf(table, startList, endList);
                };
            }
            case PREFIX: {
                return (table, tkvList) -> HgScanQuery.ScanBuilder.prefixOf(table, tkvList.stream().map(e -> e.getKey()).collect(Collectors.toList()));
            }
        }
        return (table, tkvList) -> HgScanQuery.ScanBuilder.tableOf(table);
    }

    private HgKvIterator toHgKvIteratorProxy(List<HgKvIterator> iteratorList, long limit) {
        boolean isAllOrderedLimiter = iteratorList.stream().allMatch(e -> e instanceof HgKvOrderedIterator);
        HgKvIterator iterator = isAllOrderedLimiter ? new SequencedIterator(iteratorList.stream().map(e -> (HgKvOrderedIterator)e).collect(Collectors.toList()), limit) : new TopWorkIteratorProxy(iteratorList, limit);
        return iterator;
    }

    HgStoreNode getStoreNode(Long nodeId) {
        HgStoreNode res = this.nodeManager.applyNode(this.graphName, nodeId);
        if (res == null) {
            throw HgStoreClientUtil.err("Failed to apply for an instance of HgStoreNode from node-manager.");
        }
        return res;
    }

    public boolean doAction(String table, HgOwnerKey startKey, HgOwnerKey endKey, Function<NodeTkv, Boolean> action) {
        Collection<HgNodePartition> partitions = this.doPartition(table, startKey.getOwner(), endKey.getOwner());
        for (HgNodePartition partition : partitions) {
            HgStoreNode storeNode = this.getStoreNode(partition.getNodeId());
            HgStoreSession session = this.txExecutor.openNodeSession(storeNode);
            NodeTkv data = new NodeTkv(partition, table, startKey, endKey);
            data.setSession(session);
            if (action.apply(data).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean doAction(String table, HgOwnerKey startKey, Integer code, Function<NodeTkv, Boolean> action) {
        Collection<HgNodePartition> partitions = this.doPartition(table, code);
        for (HgNodePartition partition : partitions) {
            HgStoreNode storeNode = this.getStoreNode(partition.getNodeId());
            HgStoreSession session = this.txExecutor.openNodeSession(storeNode);
            NodeTkv data = new NodeTkv(partition, table, startKey, code);
            data.setSession(session);
            if (action.apply(data).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private List<NodeTkv> toNodeTkvList(ScanStreamReq.Builder scanReqBuilder) {
        String table = scanReqBuilder.getTable();
        HgOwnerKey ownerKey = HgStoreClientConst.ALL_PARTITION_OWNER_KEY;
        byte[] allOwner = ownerKey.getOwner();
        Collection<HgNodePartition> partitions = this.doPartition(table, allOwner, allOwner);
        ArrayList<NodeTkv> nodeTkvs = new ArrayList<NodeTkv>(partitions.size());
        for (HgNodePartition partition : partitions) {
            nodeTkvs.add(new NodeTkv(partition, table, ownerKey, ownerKey));
        }
        return nodeTkvs;
    }

    private List<NodeTkv> toNodeTkvList(String table) {
        Collection<HgNodePartition> partitions = this.doPartition(table, HgStoreClientConst.ALL_PARTITION_OWNER_KEY.getOwner(), HgStoreClientConst.ALL_PARTITION_OWNER_KEY.getOwner());
        ArrayList<NodeTkv> nodeTkvs = new ArrayList<NodeTkv>(partitions.size());
        for (HgNodePartition partition : partitions) {
            nodeTkvs.add(new NodeTkv(partition, table, HgStoreClientConst.ALL_PARTITION_OWNER_KEY, HgStoreClientConst.ALL_PARTITION_OWNER_KEY));
        }
        return nodeTkvs;
    }

    private List<NodeTkv> toNodeTkvList(String table, HgOwnerKey ownerKey) {
        Collection<HgNodePartition> partitions = this.doPartition(table, ownerKey.getOwner(), ownerKey.getOwner());
        ArrayList<NodeTkv> nodeTkvs = new ArrayList<NodeTkv>(partitions.size());
        for (HgNodePartition partition : partitions) {
            nodeTkvs.add(new NodeTkv(partition, table, ownerKey, ownerKey));
        }
        return nodeTkvs;
    }

    private List<NodeTkv> toNodeTkvList(String table, HgOwnerKey startKey, HgOwnerKey endKey) {
        Collection<HgNodePartition> partitions = this.doPartition(table, startKey.getOwner(), endKey.getOwner());
        ArrayList<NodeTkv> nodeTkvs = new ArrayList<NodeTkv>(partitions.size());
        for (HgNodePartition partition : partitions) {
            nodeTkvs.add(new NodeTkv(partition, table, startKey, endKey));
        }
        return nodeTkvs;
    }

    private List<NodeTkv> toNodeTkvList(String table, int startCode, int endCode) {
        Collection<HgNodePartition> partitions = this.doPartition(table, startCode, endCode);
        ArrayList<NodeTkv> nodeTkvs = new ArrayList<NodeTkv>(partitions.size());
        for (HgNodePartition partition : partitions) {
            nodeTkvs.add(new NodeTkv(partition, table, HgOwnerKey.codeOf(startCode), HgOwnerKey.codeOf(endCode)));
        }
        return nodeTkvs;
    }

    private Collection<HgNodePartition> doPartition(String table, byte[] startKey, byte[] endKey) {
        HgNodePartitionerBuilder partitionerBuilder = HgNodePartitionerBuilder.resetAndGet();
        int status = this.nodePartitioner.partition(partitionerBuilder, this.graphName, startKey, endKey);
        if (status != 0) {
            throw HgStoreClientUtil.err("The node-partitioner is not work.");
        }
        Collection<HgNodePartition> partitions = partitionerBuilder.getPartitions();
        if (partitions.isEmpty()) {
            throw HgStoreClientUtil.err("Failed to get the collection of HgNodePartition from node-partitioner.");
        }
        return partitions;
    }

    private Collection<HgNodePartition> doPartition(String table, int startCode, int endCode) {
        HgNodePartitionerBuilder partitionerBuilder = HgNodePartitionerBuilder.resetAndGet();
        int status = this.nodePartitioner.partition(partitionerBuilder, this.graphName, startCode, endCode);
        if (status != 0) {
            throw HgStoreClientUtil.err("The node-partitioner is not work.");
        }
        Collection<HgNodePartition> partitions = partitionerBuilder.getPartitions();
        if (partitions.isEmpty()) {
            throw HgStoreClientUtil.err("Failed to get the collection of HgNodePartition from node-partitioner.");
        }
        return partitions;
    }

    Collection<HgNodePartition> doPartition(String table, int partitionId) {
        HgNodePartitionerBuilder partitionerBuilder = HgNodePartitionerBuilder.resetAndGet();
        int status = this.nodePartitioner.partition(partitionerBuilder, this.graphName, partitionId);
        if (status != 0) {
            throw HgStoreClientUtil.err("The node-partitioner is not work.");
        }
        Collection<HgNodePartition> partitions = partitionerBuilder.getPartitions();
        if (partitions.isEmpty()) {
            throw HgStoreClientUtil.err("Failed to get the collection of HgNodePartition from node-partitioner.");
        }
        return partitions;
    }

    private Stream<HgPair<HgStoreNode, NodeTkv>> getNodeStream(String table) {
        return this.toNodeTkvList(table).stream().map(e -> new HgPair((Object)this.getStoreNode(e.getNodeId()), e));
    }

    Stream<HgPair<HgStoreNode, NodeTkv>> getNodeStream(String table, HgOwnerKey ownerKey) {
        return this.toNodeTkvList(table, ownerKey).stream().map(e -> new HgPair((Object)this.getStoreNode(e.getNodeId()), e));
    }

    Stream<HgPair<HgStoreNode, NodeTkv>> getNodeStream(String table, HgOwnerKey startKey, HgOwnerKey endKey) {
        return this.toNodeTkvList(table, startKey, endKey).stream().map(e -> new HgPair((Object)this.getStoreNode(e.getNodeId()), e));
    }

    List<HgPair<HgStoreNode, NodeTkv>> getNode(String table, HgOwnerKey ownerKey) {
        List<NodeTkv> nodeTkvList = this.toNodeTkvList(table, ownerKey);
        return this.nodeTkv2Node(nodeTkvList);
    }

    List<HgPair<HgStoreNode, NodeTkv>> getNode(String table, HgOwnerKey startKey, HgOwnerKey endKey) {
        List<NodeTkv> nodeTkvList = this.toNodeTkvList(table, startKey, endKey);
        return this.nodeTkv2Node(nodeTkvList);
    }

    private List<HgPair<HgStoreNode, NodeTkv>> nodeTkv2Node(Collection<NodeTkv> nodeTkvList) {
        ArrayList<HgPair<HgStoreNode, NodeTkv>> hgPairs = new ArrayList<HgPair<HgStoreNode, NodeTkv>>(nodeTkvList.size());
        for (NodeTkv nodeTkv : nodeTkvList) {
            hgPairs.add((HgPair<HgStoreNode, NodeTkv>)new HgPair((Object)this.getStoreNode(nodeTkv.getNodeId()), (Object)nodeTkv));
        }
        return hgPairs;
    }
}

