/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.Objects;

public final class HgNodePartition {
    private final Long nodeId;
    private final Integer keyCode;
    private final Integer startKey;
    private final Integer endKey;
    private int hash = -1;

    HgNodePartition(Long nodeId, Integer keyCode) {
        this.nodeId = nodeId;
        this.keyCode = keyCode;
        this.startKey = this.endKey = keyCode;
    }

    HgNodePartition(Long nodeId, Integer keyCode, Integer startKey, Integer endKey) {
        this.nodeId = nodeId;
        this.keyCode = keyCode;
        this.startKey = startKey;
        this.endKey = endKey;
    }

    public static HgNodePartition of(Long nodeId, Integer keyCode) {
        return new HgNodePartition(nodeId, keyCode);
    }

    public static HgNodePartition of(Long nodeId, Integer keyCode, Integer startKey, Integer endKey) {
        return new HgNodePartition(nodeId, keyCode, startKey, endKey);
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public Integer getStartKey() {
        return this.startKey;
    }

    public Integer getEndKey() {
        return this.endKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgNodePartition that = (HgNodePartition)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.keyCode, that.keyCode);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = Objects.hash(this.nodeId, this.keyCode);
        }
        return this.hash;
    }

    public String toString() {
        return "HgNodePartition{nodeId=" + this.nodeId + ", partitionId=" + this.keyCode + "}";
    }
}

