/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.linked.FrequencySketch;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.LongArrayList;
import org.caffinitas.ohc.linked.OffHeapLinkedMap;

final class OffHeapLinkedWTinyLFUMap
extends OffHeapLinkedMap {
    private long edenLruHead;
    private long edenLruTail;
    private long edenFreeCapacity;
    private long edenCapacity;
    private long mainLruHead;
    private long mainLruTail;
    private long mainFreeCapacity;
    private long mainCapacity;
    private long probationCapacity;
    private FrequencySketch frequencySketch;
    private final double edenSize;

    OffHeapLinkedWTinyLFUMap(OHCacheBuilder builder, long freeCapacity) {
        super(builder);
        this.edenSize = builder.getEdenSize();
        if (this.edenSize <= 0.0) {
            throw new IllegalArgumentException("Illegal edenSize, must be > 0");
        }
        this.updateFreeCapacity(freeCapacity);
        int freqSketchSize = builder.getFrequencySketchSize();
        if (freqSketchSize <= 0) {
            freqSketchSize = this.table.size();
        }
        this.frequencySketch = new FrequencySketch(freqSketchSize);
    }

    @Override
    void release() {
        boolean wasFirst = this.lock();
        try {
            this.frequencySketch.release();
            super.release();
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @Override
    long freeCapacity() {
        return this.edenFreeCapacity + this.mainFreeCapacity;
    }

    @Override
    void updateFreeCapacity(long diff) {
        long edenPart = (long)(this.edenSize * (double)diff);
        long mainPart = diff - edenPart;
        this.edenFreeCapacity += edenPart;
        this.edenCapacity += edenPart;
        this.mainFreeCapacity += mainPart;
        this.mainCapacity += mainPart;
        this.probationCapacity = (long)(this.edenSize * (double)this.mainCapacity);
    }

    @Override
    LongArrayList ensureFreeSpaceForNewEntry(long bytes) {
        if (this.edenFreeCapacity >= bytes) {
            return null;
        }
        if (this.edenCapacity < bytes) {
            return null;
        }
        long candidateAdr = this.edenLruTail;
        if (this.mainLruTail == 0L || this.mainFreeCapacity >= bytes) {
            this.moveCandidateFromEdenToMain(candidateAdr);
            return null;
        }
        long victimAdr = this.mainLruTail;
        LongArrayList derefList = null;
        long probationUsed = this.probationUsed();
        while (bytes > this.edenFreeCapacity && probationUsed > 0L) {
            if (candidateAdr == 0L) {
                throw new AssertionError();
            }
            if (victimAdr == 0L) {
                throw new AssertionError();
            }
            long nextCandidateAdr = HashEntries.getLRUPrev(candidateAdr);
            long nextVictimAdr = HashEntries.getLRUPrev(victimAdr);
            int candidateFreq = this.frequencySketch.frequency(HashEntries.getHash(candidateAdr));
            int victimFreq = this.frequencySketch.frequency(HashEntries.getHash(victimAdr));
            probationUsed -= HashEntries.getAllocLen(victimAdr);
            if (this.admit(candidateFreq, victimFreq)) {
                derefList = this.evictEntry(derefList, victimAdr);
                this.moveCandidateFromEdenToMain(candidateAdr);
            } else {
                derefList = this.evictEntry(derefList, candidateAdr);
            }
            candidateAdr = nextCandidateAdr;
            victimAdr = nextVictimAdr;
        }
        return derefList;
    }

    @Override
    boolean hasFreeSpaceForNewEntry(long bytes) {
        return this.edenFreeCapacity >= bytes;
    }

    private LongArrayList evictEntry(LongArrayList derefList, long targetAdr) {
        this.removeInternal(targetAdr, -1L, true);
        --this.size;
        ++this.evictedEntries;
        if (derefList == null) {
            derefList = new LongArrayList();
        }
        derefList.add(targetAdr);
        return derefList;
    }

    private void moveCandidateFromEdenToMain(long candidateAdr) {
        this.removeFromLruAndUpdateCapacity(candidateAdr);
        HashEntries.setGeneration(candidateAdr, 1);
        this.addToLruAndUpdateCapacity(candidateAdr);
    }

    private long probationUsed() {
        return -this.mainFreeCapacity + this.probationCapacity;
    }

    private boolean admit(int candidateFreq, int victimFreq) {
        if (candidateFreq > victimFreq) {
            return true;
        }
        if (candidateFreq <= 5) {
            return false;
        }
        return this.frequencySketch.tieAdmit();
    }

    @Override
    void addToLruAndUpdateCapacity(long hashEntryAdr) {
        int gen = HashEntries.getGeneration(hashEntryAdr);
        long h = this.lruHead(gen);
        HashEntries.setLRUNext(hashEntryAdr, h);
        if (h != 0L) {
            HashEntries.setLRUPrev(h, hashEntryAdr);
        }
        HashEntries.setLRUPrev(hashEntryAdr, 0L);
        this.lruHead(gen, hashEntryAdr);
        if (this.lruTail(gen) == 0L) {
            this.lruTail(gen, hashEntryAdr);
        }
        this.adjustFreeCapacity(gen, -HashEntries.getAllocLen(hashEntryAdr));
    }

    @Override
    void removeFromLruAndUpdateCapacity(long hashEntryAdr) {
        int gen = HashEntries.getGeneration(hashEntryAdr);
        long next = HashEntries.getLRUNext(hashEntryAdr);
        long prev = HashEntries.getLRUPrev(hashEntryAdr);
        if (this.lruHead(gen) == hashEntryAdr) {
            this.lruHead(gen, next);
        }
        if (this.lruTail(gen) == hashEntryAdr) {
            this.lruTail(gen, prev);
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, prev);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, next);
        }
        this.adjustFreeCapacity(gen, HashEntries.getAllocLen(hashEntryAdr));
    }

    @Override
    void clearLruAndCapacity() {
        this.mainLruTail = 0L;
        this.mainLruHead = 0L;
        this.edenLruTail = 0L;
        this.edenLruHead = 0L;
        this.edenFreeCapacity = this.edenCapacity;
        this.mainFreeCapacity = this.mainCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long[] hotN(int n) {
        boolean wasFirst = this.lock();
        try {
            long[] r = new long[n];
            int i = 0;
            long hashEntryAdr = this.mainLruHead;
            while (hashEntryAdr != 0L && i < n) {
                r[i++] = hashEntryAdr;
                HashEntries.reference(hashEntryAdr);
                hashEntryAdr = HashEntries.getLRUNext(hashEntryAdr);
            }
            hashEntryAdr = this.edenLruHead;
            while (hashEntryAdr != 0L && i < n) {
                r[i++] = hashEntryAdr;
                HashEntries.reference(hashEntryAdr);
                hashEntryAdr = HashEntries.getLRUNext(hashEntryAdr);
            }
            long[] lArray = r;
            return lArray;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @Override
    void replaceSentinelInLruAndUpdateCapacity(long hashEntryAdr, long newHashEntryAdr, long bytes) {
        int gen = HashEntries.getGeneration(hashEntryAdr);
        HashEntries.setGeneration(newHashEntryAdr, gen);
        long next = HashEntries.getLRUNext(hashEntryAdr);
        long prev = HashEntries.getLRUPrev(hashEntryAdr);
        HashEntries.setLRUNext(newHashEntryAdr, next);
        HashEntries.setLRUPrev(newHashEntryAdr, prev);
        if (this.lruHead(gen) == hashEntryAdr) {
            this.lruHead(gen, newHashEntryAdr);
        }
        if (this.lruTail(gen) == hashEntryAdr) {
            this.lruTail(gen, newHashEntryAdr);
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, newHashEntryAdr);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, newHashEntryAdr);
        }
        this.adjustFreeCapacity(gen, -bytes);
    }

    @Override
    void touch(long hashEntryAdr) {
        this.frequencySketch.increment(HashEntries.getHash(hashEntryAdr));
        int gen = HashEntries.getGeneration(hashEntryAdr);
        long head = this.lruHead(gen);
        if (head == hashEntryAdr) {
            return;
        }
        long next = HashEntries.getAndSetLRUNext(hashEntryAdr, head);
        long prev = HashEntries.getAndSetLRUPrev(hashEntryAdr, 0L);
        long tail = this.lruTail(gen);
        if (tail == hashEntryAdr) {
            this.lruTail(gen, prev == 0L ? hashEntryAdr : prev);
        } else if (tail == 0L) {
            this.lruTail(gen, hashEntryAdr);
        }
        if (next != 0L) {
            HashEntries.setLRUPrev(next, prev);
        }
        if (prev != 0L) {
            HashEntries.setLRUNext(prev, next);
        }
        if (head != 0L) {
            HashEntries.setLRUPrev(head, hashEntryAdr);
        }
        this.lruHead(gen, hashEntryAdr);
    }

    private void adjustFreeCapacity(int gen, long amount) {
        switch (gen) {
            case 0: {
                this.edenFreeCapacity += amount;
                break;
            }
            case 1: {
                this.mainFreeCapacity += amount;
            }
        }
    }

    private long lruHead(int gen) {
        switch (gen) {
            case 0: {
                return this.edenLruHead;
            }
            case 1: {
                return this.mainLruHead;
            }
        }
        return 0L;
    }

    private void lruHead(int gen, long hashEntryAdr) {
        switch (gen) {
            case 0: {
                this.edenLruHead = hashEntryAdr;
                break;
            }
            case 1: {
                this.mainLruHead = hashEntryAdr;
            }
        }
    }

    private long lruTail(int gen) {
        switch (gen) {
            case 0: {
                return this.edenLruTail;
            }
            case 1: {
                return this.mainLruTail;
            }
        }
        return 0L;
    }

    private void lruTail(int gen, long hashEntryAdr) {
        switch (gen) {
            case 0: {
                this.edenLruTail = hashEntryAdr;
                break;
            }
            case 1: {
                this.mainLruTail = hashEntryAdr;
            }
        }
    }
}

