/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.nio.ByteBuffer;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.linked.HashEntries;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

class DirectValueAccessImpl
implements DirectValueAccess {
    private final long hashEntryAdr;
    private boolean closed;
    private final ByteBuffer buffer;

    DirectValueAccessImpl(long hashEntryAdr, boolean readOnly) {
        long keyLen = HashEntries.getKeyLen(hashEntryAdr);
        long valueLen = HashEntries.getValueLen(hashEntryAdr);
        this.hashEntryAdr = hashEntryAdr;
        this.buffer = Uns.directBufferFor(hashEntryAdr, 64L + Util.roundUpTo8(keyLen), valueLen, readOnly);
    }

    @Override
    public ByteBuffer buffer() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        return this.buffer;
    }

    @Override
    public void close() {
        this.deref();
    }

    private void deref() {
        if (!this.closed) {
            Uns.invalidateDirectBuffer(this.buffer);
            this.closed = true;
            HashEntries.dereference(this.hashEntryAdr);
        }
    }
}

