/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

import java.nio.ByteBuffer;
import org.caffinitas.ohc.HashAlgorithm;
import org.caffinitas.ohc.chunked.Crc32Hash;
import org.caffinitas.ohc.chunked.Crc32cHash;
import org.caffinitas.ohc.chunked.Murmur3Hash;
import org.caffinitas.ohc.chunked.XxHash;

abstract class Hasher {
    Hasher() {
    }

    static Hasher create(HashAlgorithm hashAlgorithm) {
        switch (hashAlgorithm) {
            case XX: {
                try {
                    return new XxHash();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case CRC32C: {
                try {
                    return Crc32cHash.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case CRC32: {
                return new Crc32Hash();
            }
            case MURMUR3: {
                return new Murmur3Hash();
            }
        }
        throw new UnsupportedOperationException("Incomplete implementation of Hasher.create()");
    }

    private static String forAlg(HashAlgorithm hashAlgorithm) {
        return Hasher.class.getName().substring(0, Hasher.class.getName().lastIndexOf(46) + 1) + hashAlgorithm.name().charAt(0) + hashAlgorithm.name().substring(1).toLowerCase() + "Hash";
    }

    abstract long hash(ByteBuffer var1);
}

